(ns taoensso.sente.interfaces
  "Experimental (pre-alpha): subject to change.
  Public interfaces / extension points."
                                                      
         (:require [cljs.reader              :as edn]))

;;;; Servers

     
                             
                                          

;;;; Packers

(defprotocol IPacker
  "Extension pt. for client<->server comms data un/packers:
  encoded strings <-> arbitrary Clojure data."
  (pack   [_ x] #_[_ x opts])
  (unpack [_ s] #_[_ x opts]))

(deftype EdnPacker []
  IPacker
  (pack   [_ x] (pr-str x))
  (unpack [_ s] (edn/read-string s)))

(def edn-packer "Default Edn packer." (->EdnPacker))

(defn coerce-packer [packer]
  (if (identical? packer :edn)
    edn-packer
    (do (assert (satisfies? IPacker packer))
        packer)))

;; (defn pack   [packer x & [?opts]] (pack*   packer x (or ?opts {})))
;; (defn unpack [packer x & [?opts]] (unpack* packer x (or ?opts {})))

;;;;;;;;;;;; This file autogenerated from src/taoensso/sente/interfaces.cljx
