/*
 * Decompiled with CFR 0.152.
 */
package com.taoensso;

import java.io.IOException;
import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public FastByteArrayInputStream(byte[] byArray) {
        this.mark = 0;
        this.buf = byArray;
        this.count = byArray.length;
    }

    public FastByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.mark = n;
        this.count = n + n2 > byArray.length ? byArray.length : n + n2;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.count - this.pos < n2 ? this.count - this.pos : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public long skip(long l) {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.pos;
        this.pos = (long)(this.count - this.pos) < l ? this.count : (int)((long)this.pos + l);
        return this.pos - n;
    }
}

