/*
 * Decompiled with CFR 0.152.
 */
package com.taoensso;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public FastByteArrayOutputStream() {
        this.buf = new byte[32];
    }

    public FastByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void expand(int n) {
        if (this.count + n <= this.buf.length) {
            return;
        }
        byte[] byArray = new byte[(this.count + n) * 2];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.buf = byArray;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Deprecated
    public String toString(int n) {
        char[] cArray = new char[this.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((n & 0xFF) << 8 | this.buf[i] & 0xFF);
        }
        return new String(cArray);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.expand(n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    @Override
    public void write(int n) {
        if (this.count == this.buf.length) {
            this.expand(1);
        }
        this.buf[this.count++] = (byte)n;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }
}

