/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.httpkit.HttpUtils;
import org.httpkit.LineTooLargeException;
import org.httpkit.ProtocolException;
import org.httpkit.RequestTooLargeException;
import org.httpkit.server.AsyncChannel;
import org.httpkit.server.ClojureRing;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.HttpServerAtta;
import org.httpkit.server.IHandler;
import org.httpkit.server.ResponseCallback;
import org.httpkit.server.ServerAtta;
import org.httpkit.ws.CloseFrame;
import org.httpkit.ws.PingFrame;
import org.httpkit.ws.TextFrame;
import org.httpkit.ws.WSEncoder;
import org.httpkit.ws.WSFrame;
import org.httpkit.ws.WsServerAtta;

public class HttpServer
implements Runnable {
    static final String THREAD_NAME = "server-loop";
    private final IHandler handler;
    private final int maxBody;
    private final int maxLine;
    private final Selector selector;
    private final ServerSocketChannel serverChannel;
    private Thread serverThread;
    private final ConcurrentLinkedQueue<SelectionKey> pendings = new ConcurrentLinkedQueue();
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(65536);

    public HttpServer(String ip, int port, IHandler handler, int maxBody, int maxLine) throws IOException {
        this.handler = handler;
        this.maxLine = maxLine;
        this.maxBody = maxBody;
        this.selector = Selector.open();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress addr = new InetSocketAddress(ip, port);
        this.serverChannel.socket().bind(addr);
        this.serverChannel.register(this.selector, 16);
    }

    void accept(SelectionKey key) {
        ServerSocketChannel ch = (ServerSocketChannel)key.channel();
        try {
            SocketChannel s;
            while ((s = ch.accept()) != null) {
                s.configureBlocking(false);
                HttpServerAtta atta = new HttpServerAtta(this.maxBody, this.maxLine);
                SelectionKey k = s.register(this.selector, 1, atta);
                atta.asycChannel = new AsyncChannel(k, this);
            }
        }
        catch (Exception e) {
            HttpUtils.printError("accept incoming request", e);
        }
    }

    private void closeKey(SelectionKey key, int status) {
        try {
            key.channel().close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ServerAtta att = (ServerAtta)key.attachment();
        if (att instanceof HttpServerAtta) {
            this.handler.clientClose(att.asycChannel, -1);
        } else {
            this.handler.clientClose(att.asycChannel, status);
        }
    }

    private void decodeHttp(HttpServerAtta atta, SelectionKey key, SocketChannel ch) {
        try {
            do {
                atta.asycChannel.reset();
                HttpRequest request = atta.decoder.decode(this.buffer);
                if (request == null) continue;
                if (request.isWebSocket) {
                    key.attach(new WsServerAtta(atta.asycChannel));
                } else {
                    atta.keepalive = request.isKeepAlive;
                }
                request.asycChannel = atta.asycChannel;
                request.remoteAddr = (InetSocketAddress)ch.socket().getRemoteSocketAddress();
                this.handler.handle(request, new ResponseCallback(key, this));
                atta.decoder.reset();
            } while (this.buffer.hasRemaining());
        }
        catch (ProtocolException e) {
            this.closeKey(key, -1);
        }
        catch (RequestTooLargeException e) {
            ByteBuffer[] buffers = ClojureRing.encode(413, null, e.getMessage());
            atta.addBuffer(buffers);
            atta.keepalive = false;
            key.interestOps(4);
        }
        catch (LineTooLargeException e) {
            ByteBuffer[] buffers = ClojureRing.encode(414, null, e.getMessage());
            atta.keepalive = false;
            atta.addBuffer(buffers);
            key.interestOps(4);
        }
    }

    private void decodeWs(WsServerAtta atta, SelectionKey key) {
        try {
            do {
                WSFrame frame;
                if ((frame = atta.decoder.decode(this.buffer)) instanceof TextFrame) {
                    this.handler.handle(atta.asycChannel, (TextFrame)frame);
                    atta.decoder.reset();
                    continue;
                }
                if (frame instanceof PingFrame) {
                    atta.addBuffer(WSEncoder.encode((byte)10, frame.data));
                    atta.decoder.reset();
                    key.interestOps(4);
                    continue;
                }
                if (!(frame instanceof CloseFrame)) continue;
                this.handler.clientClose(atta.asycChannel, ((CloseFrame)frame).getStatus());
                atta.addBuffer(WSEncoder.encode((byte)8, frame.data));
                key.interestOps(4);
            } while (this.buffer.hasRemaining());
        }
        catch (ProtocolException e) {
            System.err.printf("%s [%s] WARN - %s\n", new Date(), THREAD_NAME, e.getMessage());
            this.closeKey(key, 1009);
        }
    }

    private void doRead(SelectionKey key) {
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            this.buffer.clear();
            int read = ch.read(this.buffer);
            if (read == -1) {
                this.closeKey(key, 1001);
            } else if (read > 0) {
                ServerAtta atta = (ServerAtta)key.attachment();
                this.buffer.flip();
                if (atta instanceof HttpServerAtta) {
                    this.decodeHttp((HttpServerAtta)atta, key, ch);
                } else {
                    this.decodeWs((WsServerAtta)atta, key);
                }
            }
        }
        catch (IOException e) {
            this.closeKey(key, 1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(SelectionKey key) {
        ServerAtta atta = (ServerAtta)key.attachment();
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            LinkedList<ByteBuffer> toWrites = atta.toWrites;
            LinkedList<ByteBuffer> linkedList = atta.toWrites;
            synchronized (linkedList) {
                int size = toWrites.size();
                if (size == 1) {
                    ch.write(toWrites.get(0));
                } else if (size > 0) {
                    ByteBuffer[] buffers = new ByteBuffer[size];
                    toWrites.toArray(buffers);
                    ch.write(buffers);
                }
                Iterator ite = toWrites.iterator();
                while (ite.hasNext()) {
                    if (((ByteBuffer)ite.next()).hasRemaining()) continue;
                    ite.remove();
                }
                if (toWrites.size() == 0) {
                    if (atta.isKeepAlive()) {
                        key.interestOps(1);
                    } else {
                        this.closeKey(key, 1000);
                    }
                }
            }
        }
        catch (IOException e) {
            this.closeKey(key, 1001);
        }
    }

    public void queueWrite(SelectionKey key) {
        this.pendings.add(key);
        this.selector.wakeup();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    SelectionKey k = null;
                    while ((k = this.pendings.poll()) != null) {
                        if (!k.isValid()) continue;
                        k.interestOps(4);
                    }
                    if (this.selector.select() <= 0) continue;
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    for (SelectionKey key : selectedKeys) {
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            this.accept(key);
                            continue;
                        }
                        if (key.isReadable()) {
                            this.doRead(key);
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        this.doWrite(key);
                    }
                    selectedKeys.clear();
                }
            }
            catch (ClosedSelectorException ignore) {
                return;
            }
            catch (Exception e) {
                HttpUtils.printError("http server loop error, should not happen", e);
                continue;
            }
            break;
        }
    }

    public void start() throws IOException {
        this.serverThread = new Thread((Runnable)this, THREAD_NAME);
        this.serverThread.start();
    }

    public void stop() {
        if (this.selector.isOpen()) {
            try {
                this.serverChannel.close();
                Set<SelectionKey> keys = this.selector.keys();
                for (SelectionKey k : keys) {
                    k.channel().close();
                }
                this.selector.close();
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverThread.interrupt();
        }
    }
}

