/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.httpkit.HttpUtils;
import org.httpkit.server.ClojureRing;
import org.httpkit.server.HttpServer;
import org.httpkit.server.LinkingRunnable;
import org.httpkit.server.ServerAtta;
import org.httpkit.ws.WSEncoder;
import org.httpkit.ws.WsServerAtta;

public class AsyncChannel {
    private final SelectionKey key;
    private final HttpServer server;
    public final AtomicReference<Boolean> closedRan = new AtomicReference<Boolean>(false);
    final AtomicReference<IFn> closeHandler = new AtomicReference<Object>(null);
    private volatile IFn onSendHook;
    private volatile IFn onReceiveHook;
    private static IFn globalSentHook;
    private static IFn globalReceiveHook;
    final AtomicReference<IFn> receiveHandler = new AtomicReference<Object>(null);
    private volatile boolean isInitialWrite = true;
    LinkingRunnable serialTask;
    private static final byte[] finalChunkBytes;
    private static final byte[] newLineBytes;
    static Keyword K_BY_SERVER;
    static Keyword K_CLIENT_CLOSED;
    static Keyword K_WS_1000;
    static Keyword K_WS_1001;
    static Keyword K_WS_1002;
    static Keyword K_WS_1003;
    static Keyword K_UNKNOW;

    public AsyncChannel(SelectionKey key, HttpServer server) {
        this.key = key;
        this.server = server;
    }

    public void reset() {
        this.closedRan.lazySet(false);
        this.closeHandler.lazySet(null);
        this.receiveHandler.lazySet(null);
        this.isInitialWrite = true;
        this.onSendHook = null;
        this.onReceiveHook = null;
        this.serialTask = null;
    }

    private static ByteBuffer chunkSize(int size) {
        String s = Integer.toHexString(size) + "\r\n";
        return ByteBuffer.wrap(s.getBytes());
    }

    private void firstWrite(Object data, boolean isFinal) throws IOException {
        ByteBuffer[] buffers;
        int status = 200;
        Object body = data;
        TreeMap<String, Object> headers = new TreeMap<String, String>();
        if (data instanceof Map) {
            Map resp = (Map)data;
            headers = ClojureRing.getHeaders(resp, false);
            status = ClojureRing.getStatus(resp);
            body = resp.get(ClojureRing.BODY);
        }
        if (headers.isEmpty()) {
            headers.put("Content-Type", "text/html; charset=utf-8");
        }
        if (isFinal) {
            buffers = ClojureRing.encode(status, headers, body);
        } else {
            headers.put("Transfer-Encoding", "chunked");
            ByteBuffer[] bb = ClojureRing.encode(status, headers, body);
            buffers = body == null ? bb : new ByteBuffer[]{bb[0], AsyncChannel.chunkSize(bb[1].remaining()), bb[1], ByteBuffer.wrap(newLineBytes)};
        }
        if (isFinal) {
            this.onClose(0);
        }
        this.write(buffers);
    }

    private void writeChunk(Object body) throws IOException {
        if (body instanceof Map) {
            body = ((Map)body).get(ClojureRing.BODY);
        }
        if (body != null) {
            ByteBuffer t = HttpUtils.bodyBuffer(body);
            ByteBuffer size = AsyncChannel.chunkSize(t.remaining());
            ByteBuffer[] buffers = new ByteBuffer[]{size, t, ByteBuffer.wrap(newLineBytes)};
            this.write(buffers);
        }
    }

    public void setReceiveHandler(IFn fn) {
        if (!this.receiveHandler.compareAndSet(null, fn)) {
            throw new IllegalStateException("receive handler exist: " + this.receiveHandler.get());
        }
    }

    public void messageReceived(String mesg) {
        IFn f = this.receiveHandler.get();
        if (f != null) {
            IFn hook;
            IFn iFn = hook = this.onReceiveHook == null ? globalReceiveHook : this.onReceiveHook;
            if (hook != null) {
                f.invoke(hook.invoke((Object)mesg));
            } else {
                f.invoke((Object)mesg);
            }
        }
    }

    private void sendTextFrame(String mesg) {
        this.write(WSEncoder.encode(mesg));
    }

    public void sendHandshake(Map<String, Object> headers) {
        this.write(ClojureRing.encode(101, headers, null));
    }

    public void setCloseHandler(IFn fn) {
        if (!this.closeHandler.compareAndSet(null, fn)) {
            throw new IllegalStateException("close handler exist: " + this.closeHandler.get());
        }
        if (this.closedRan.get().booleanValue()) {
            fn.invoke((Object)K_UNKNOW);
        }
    }

    public void onClose(int status) {
        IFn f;
        if (this.closedRan.compareAndSet(false, true) && (f = this.closeHandler.get()) != null) {
            f.invoke((Object)AsyncChannel.closeReason(status));
        }
    }

    public boolean serverClose(int status) {
        if (!this.closedRan.compareAndSet(false, true)) {
            return false;
        }
        if (this.isWebSocket()) {
            this.write(WSEncoder.encode((byte)8, ByteBuffer.allocate(2).putShort((short)status).array()));
        } else {
            this.write(ByteBuffer.wrap(finalChunkBytes));
        }
        IFn f = this.closeHandler.get();
        if (f != null) {
            f.invoke((Object)AsyncChannel.closeReason(0));
        }
        return true;
    }

    public boolean send(Object data, boolean closeAfterSent) throws IOException {
        IFn hook;
        if (this.closedRan.get().booleanValue()) {
            return false;
        }
        IFn iFn = hook = this.onSendHook == null ? globalSentHook : this.onSendHook;
        if (hook != null) {
            data = hook.invoke(data, (Object)this.isWebSocket(), (Object)this.isFirstWrite());
        }
        if (this.isWebSocket()) {
            if (!(data instanceof String)) {
                throw new IllegalArgumentException("websocket only accept string, get" + data);
            }
            this.sendTextFrame((String)data);
            if (closeAfterSent) {
                this.serverClose(1000);
            }
        } else if (this.isInitialWrite) {
            this.firstWrite(data, closeAfterSent);
            this.isInitialWrite = false;
        } else {
            this.writeChunk(data);
        }
        return true;
    }

    public static void setGlobalHook(IFn sentHook, IFn receiveHook) {
        globalSentHook = sentHook;
        globalReceiveHook = receiveHook;
    }

    public void alterSentHook(IFn f) {
        this.onSendHook = (IFn)f.invoke((Object)(this.onSendHook == null ? globalSentHook : this.onSendHook));
    }

    public void alterReceiveHook(IFn f) {
        this.onReceiveHook = (IFn)f.invoke((Object)(this.onReceiveHook == null ? globalReceiveHook : this.onReceiveHook));
    }

    public String toString() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return s.getLocalSocketAddress() + "<->" + s.getRemoteSocketAddress();
    }

    private void write(ByteBuffer ... buffers) {
        ServerAtta atta = (ServerAtta)this.key.attachment();
        atta.addBuffer(buffers);
        this.server.queueWrite(this.key);
    }

    public boolean isWebSocket() {
        return this.key.attachment() instanceof WsServerAtta;
    }

    public boolean isFirstWrite() {
        return !this.isWebSocket() && this.isInitialWrite;
    }

    public boolean isClosed() {
        return this.closedRan.get();
    }

    static Keyword closeReason(int status) {
        switch (status) {
            case 0: {
                return K_BY_SERVER;
            }
            case -1: {
                return K_CLIENT_CLOSED;
            }
            case 1000: {
                return K_WS_1000;
            }
            case 1001: {
                return K_WS_1001;
            }
            case 1002: {
                return K_WS_1002;
            }
            case 1003: {
                return K_WS_1003;
            }
        }
        return K_UNKNOW;
    }

    static {
        finalChunkBytes = "0\r\n\r\n".getBytes();
        newLineBytes = "\r\n".getBytes();
        K_BY_SERVER = Keyword.intern((String)"server-close");
        K_CLIENT_CLOSED = Keyword.intern((String)"http-client-close");
        K_WS_1000 = Keyword.intern((String)"ws-normal");
        K_WS_1001 = Keyword.intern((String)"ws-going-away");
        K_WS_1002 = Keyword.intern((String)"ws-protocol-error");
        K_WS_1003 = Keyword.intern((String)"ws-unsupported");
        K_UNKNOW = Keyword.intern((String)"ws-unknow");
    }
}

