/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import org.httpkit.HttpMethod;
import org.httpkit.client.Decoder;
import org.httpkit.client.IRespListener;
import org.httpkit.client.PriorityQueue;

public class Request
implements Comparable<Request> {
    final InetSocketAddress addr;
    final Decoder decoder;
    final ByteBuffer[] request;
    private final PriorityQueue<Request> clients;
    public final int timeOutMs;
    private boolean isDone = false;
    public boolean isKeepAlived = false;
    public boolean isConnected = false;
    SelectionKey key;
    private long timeoutTs;

    public Request(InetSocketAddress addr, ByteBuffer[] request, IRespListener handler, PriorityQueue<Request> clients, int timeOutMs, HttpMethod method) {
        this.decoder = new Decoder(handler, method);
        this.timeOutMs = timeOutMs;
        this.request = request;
        this.clients = clients;
        this.addr = addr;
        this.timeoutTs = (long)this.timeOutMs + System.currentTimeMillis();
    }

    public void onProgress(long now) {
        this.clients.remove(this);
        this.timeoutTs = (long)this.timeOutMs + now;
        this.clients.offer(this);
    }

    public void finish() {
        this.clients.remove(this);
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.decoder.listener.onCompleted();
    }

    public boolean isTimeout(long now) {
        return this.timeoutTs < now;
    }

    public void finish(Throwable t) {
        this.clients.remove(this);
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.decoder.listener.onThrowable(t);
    }

    @Override
    public int compareTo(Request o) {
        return (int)(this.timeoutTs - o.timeoutTs);
    }
}

