/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.util.Arrays;

public class PriorityQueue<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue = new Object[11];
    private int size = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.queue.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = PriorityQueue.hugeCapacity(minCapacity);
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(i, e);
        }
        return true;
    }

    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[0];
    }

    public E remove(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.queue[i].equals(o)) continue;
            Object e = this.queue[i];
            this.removeAt(i);
            return (E)e;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public E poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        Object result = this.queue[0];
        Object x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return (E)result;
    }

    private E removeAt(int i) {
        int s;
        assert (i >= 0 && i < this.size);
        if ((s = --this.size) == i) {
            this.queue[i] = null;
        } else {
            Object moved = this.queue[s];
            this.queue[s] = null;
            this.siftDown(i, moved);
            if (this.queue[i] == moved) {
                this.siftUp(i, moved);
                if (this.queue[i] != moved) {
                    return (E)moved;
                }
            }
        }
        return null;
    }

    private void siftUp(int k, E x) {
        int parent;
        Object e;
        Comparable key = (Comparable)x;
        while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = key;
    }

    private void siftDown(int k, E x) {
        Comparable key = (Comparable)x;
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && ((Comparable)c).compareTo(this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (key.compareTo(c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = key;
    }

    public String toString() {
        return "size=" + this.size;
    }
}

