/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.util.Map;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.client.IBinaryHandler;
import me.shenfeng.http.client.IRespListener;

public class BinaryRespListener
implements IRespListener {
    protected DynamicBytes body = new DynamicBytes(8192);
    protected Map<String, String> headers;
    protected HttpStatus status;
    protected IBinaryHandler handler;

    public BinaryRespListener(IBinaryHandler h) {
        this.handler = h;
    }

    @Override
    public int onBodyReceived(byte[] buf, int length) {
        this.body.append(buf, 0, length);
        return 1;
    }

    @Override
    public void onCompleted() {
        this.handler.onSuccess(this.status.getCode(), this.headers, this.body);
    }

    @Override
    public int onHeadersReceived(Map<String, String> headers) {
        this.headers = headers;
        return 1;
    }

    @Override
    public int onInitialLineReceived(HttpVersion version, HttpStatus status) {
        this.status = status;
        return 1;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.handler.onThrowable(t);
    }
}

