/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import clojure.lang.IFn;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.PrefixThreafFactory;
import me.shenfeng.http.server.ClojureRing;
import me.shenfeng.http.server.HttpHandler;
import me.shenfeng.http.server.HttpRequest;
import me.shenfeng.http.server.IHandler;
import me.shenfeng.http.server.ResponseCallback;
import me.shenfeng.http.ws.CloseFrame;
import me.shenfeng.http.ws.TextFrame;
import me.shenfeng.http.ws.WSFrame;
import me.shenfeng.http.ws.WsCon;

public class RingHandler
implements IHandler {
    final ExecutorService execs;
    final IFn handler;
    final int queueSize;

    public RingHandler(int thread, IFn handler, String prefix, int queueSize) {
        this.queueSize = queueSize;
        PrefixThreafFactory factory = new PrefixThreafFactory(prefix);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueSize);
        this.execs = new ThreadPoolExecutor(thread, thread, 0L, TimeUnit.MILLISECONDS, queue, factory);
        this.handler = handler;
    }

    @Override
    public void handle(HttpRequest req, ResponseCallback cb) {
        try {
            this.execs.submit(new HttpHandler(req, cb, this.handler));
        }
        catch (RejectedExecutionException e) {
            HttpUtils.printError("queue size exceeds the limit " + this.queueSize + ", please increase :queue-size when run-server if this happens often", e);
            cb.run(ClojureRing.encode(503, new TreeMap<String, Object>(), "server is overloaded, please try later"));
        }
    }

    @Override
    public void close() {
        this.execs.shutdownNow();
    }

    @Override
    public void handle(final WsCon con, final WSFrame frame) {
        this.execs.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (frame instanceof TextFrame) {
                        con.messageRecieved(((TextFrame)frame).getText());
                    } else if (frame instanceof CloseFrame) {
                        con.clientClosed(((CloseFrame)frame).getStatus());
                    }
                }
                catch (Throwable e) {
                    HttpUtils.printError("handle websocket frame " + frame, e);
                }
            }
        });
    }
}

