/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.LineTooLargeException;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.RequestTooLargeException;
import me.shenfeng.http.server.ClojureRing;
import me.shenfeng.http.server.HttpRequest;
import me.shenfeng.http.server.HttpServerAtta;
import me.shenfeng.http.server.IHandler;
import me.shenfeng.http.server.RequestDecoder;
import me.shenfeng.http.server.ResponseCallback;
import me.shenfeng.http.server.ServerAtta;
import me.shenfeng.http.ws.CloseFrame;
import me.shenfeng.http.ws.PingFrame;
import me.shenfeng.http.ws.TextFrame;
import me.shenfeng.http.ws.WSEncoder;
import me.shenfeng.http.ws.WSFrame;
import me.shenfeng.http.ws.WsCon;
import me.shenfeng.http.ws.WsServerAtta;

public class HttpServer {
    private final IHandler handler;
    private final int port;
    private final int maxBody;
    private final int maxLine;
    private final String ip;
    private Selector selector;
    private Thread serverThread;
    private ServerSocketChannel serverChannel;
    private ConcurrentLinkedQueue<SelectionKey> pendings = new ConcurrentLinkedQueue();
    private ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
    private Runnable eventLoop = new Runnable(){

        @Override
        public void run() {
            SelectionKey key2 = null;
            while (true) {
                try {
                    while (true) {
                        if ((key2 = (SelectionKey)HttpServer.this.pendings.poll()) != null) {
                            if (!key2.isValid()) continue;
                            key2.interestOps(4);
                            continue;
                        }
                        int select = HttpServer.this.selector.select(3000L);
                        if (select <= 0) continue;
                        Set<SelectionKey> selectedKeys = HttpServer.this.selector.selectedKeys();
                        for (SelectionKey key2 : selectedKeys) {
                            if (!key2.isValid()) continue;
                            if (key2.isAcceptable()) {
                                HttpServer.this.accept(key2, HttpServer.this.selector);
                                continue;
                            }
                            if (key2.isReadable()) {
                                HttpServer.this.doRead(key2);
                                continue;
                            }
                            if (!key2.isWritable()) continue;
                            HttpServer.this.doWrite(key2);
                        }
                        selectedKeys.clear();
                    }
                }
                catch (ClosedSelectorException ignore) {
                    HttpServer.this.selector = null;
                    return;
                }
                catch (Exception e) {
                    if (key2 != null) {
                        HttpServer.this.closeKey(key2, CloseFrame.SERVER_ERROR);
                    }
                    HttpUtils.printError("http server loop error, should not happend", e);
                    continue;
                }
                break;
            }
        }
    };

    private void closeKey(SelectionKey key, CloseFrame close) {
        SelectableChannel ch = key.channel();
        try {
            if (ch != null) {
                ch.close();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Object att = key.attachment();
        if (att instanceof WsServerAtta) {
            this.handler.handle(((WsServerAtta)att).con, close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(SelectionKey key) {
        ServerAtta atta = (ServerAtta)key.attachment();
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            LinkedList<ByteBuffer> toWrites;
            LinkedList<ByteBuffer> linkedList = toWrites = atta.toWrites;
            synchronized (linkedList) {
                if (toWrites.size() == 1) {
                    ch.write(toWrites.get(0));
                } else {
                    ByteBuffer[] buffers = new ByteBuffer[toWrites.size()];
                    toWrites.toArray(buffers);
                    ch.write(buffers);
                }
                Iterator ite = toWrites.iterator();
                while (ite.hasNext()) {
                    if (((ByteBuffer)ite.next()).hasRemaining()) continue;
                    ite.remove();
                }
                if (toWrites.size() == 0) {
                    if (atta.isKeepAlive()) {
                        key.interestOps(1);
                    } else {
                        this.closeKey(key, CloseFrame.NORMAL);
                    }
                }
            }
        }
        catch (IOException e) {
            this.closeKey(key, CloseFrame.AWAY);
        }
    }

    public void queueWrite(SelectionKey key) {
        this.pendings.add(key);
        this.selector.wakeup();
    }

    public HttpServer(String ip, int port, IHandler handler, int maxBody, int maxLine) {
        this.handler = handler;
        this.ip = ip;
        this.port = port;
        this.maxLine = maxLine;
        this.maxBody = maxBody;
    }

    void accept(SelectionKey key, Selector selector) {
        ServerSocketChannel ch = (ServerSocketChannel)key.channel();
        try {
            SocketChannel s;
            while ((s = ch.accept()) != null) {
                s.configureBlocking(false);
                s.register(selector, 1, new HttpServerAtta(this.maxBody, this.maxLine));
            }
        }
        catch (Exception e) {
            HttpUtils.printError("accept incomming request error", e);
        }
    }

    void bind() throws IOException {
        this.selector = Selector.open();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress addr = new InetSocketAddress(this.ip, this.port);
        this.serverChannel.socket().bind(addr);
        this.serverChannel.register(this.selector, 16);
    }

    private void decodeHttp(HttpServerAtta atta, SelectionKey key, SocketChannel ch) {
        RequestDecoder decoder = atta.decoder;
        try {
            do {
                if (decoder.decode(this.buffer) != RequestDecoder.State.ALL_READ) continue;
                HttpRequest request = decoder.request;
                if (request.isWs()) {
                    WsCon con = new WsCon(key, this);
                    request.setWebSocketCon(con);
                    key.attach(new WsServerAtta(con));
                }
                request.setRemoteAddr(ch.socket().getRemoteSocketAddress());
                this.handler.handle(request, new ResponseCallback(key, this));
                atta.reset();
            } while (this.buffer.hasRemaining());
        }
        catch (ProtocolException e) {
            this.closeKey(key, CloseFrame.NORMAL);
        }
        catch (RequestTooLargeException e) {
            ByteBuffer[] buffers = ClojureRing.encode(413, new TreeMap<String, Object>(), e.getMessage());
            atta.addBuffer(buffers);
            key.interestOps(4);
        }
        catch (LineTooLargeException e) {
            ByteBuffer[] buffers = ClojureRing.encode(414, new TreeMap<String, Object>(), e.getMessage());
            atta.addBuffer(buffers);
            key.interestOps(4);
        }
    }

    private void decodeWs(WsServerAtta atta, SelectionKey key, SocketChannel ch) {
        try {
            do {
                WSFrame frame;
                if ((frame = atta.decoder.decode(this.buffer)) instanceof TextFrame) {
                    this.handler.handle(atta.con, frame);
                    atta.reset();
                    continue;
                }
                if (frame instanceof PingFrame) {
                    atta.addBuffer(WSEncoder.encode((byte)10, frame.data));
                    atta.reset();
                    key.interestOps(4);
                    continue;
                }
                if (!(frame instanceof CloseFrame)) continue;
                this.handler.handle(atta.con, frame);
                atta.closeOnfinish = true;
                atta.addBuffer(WSEncoder.encode((byte)8, frame.data));
                key.interestOps(4);
            } while (this.buffer.hasRemaining());
        }
        catch (ProtocolException e) {
            this.closeKey(key, CloseFrame.MESG_BIG);
        }
    }

    private void doRead(SelectionKey key) {
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            this.buffer.clear();
            int read = ch.read(this.buffer);
            if (read == -1) {
                this.closeKey(key, CloseFrame.AWAY);
            } else if (read > 0) {
                ServerAtta atta = (ServerAtta)key.attachment();
                this.buffer.flip();
                if (atta instanceof HttpServerAtta) {
                    this.decodeHttp((HttpServerAtta)atta, key, ch);
                } else {
                    this.decodeWs((WsServerAtta)atta, key, ch);
                }
            }
        }
        catch (IOException e) {
            this.closeKey(key, CloseFrame.AWAY);
        }
    }

    public void start() throws IOException {
        this.bind();
        this.serverThread = new Thread(this.eventLoop, "http-server");
        this.serverThread.start();
    }

    public void stop() {
        if (this.selector != null) {
            try {
                this.serverChannel.close();
                this.serverChannel = null;
                Set<SelectionKey> keys = this.selector.keys();
                for (SelectionKey k : keys) {
                    k.channel().close();
                }
                this.selector.close();
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverThread.interrupt();
        }
    }
}

