/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpMethod;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.client.ClientAtta;
import me.shenfeng.http.client.ClientConnState;
import me.shenfeng.http.client.ClientDecoder;
import me.shenfeng.http.client.ClientDecoderState;
import me.shenfeng.http.client.HttpClientConfig;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.client.TextRespListener;
import me.shenfeng.http.client.TimeoutException;

public final class HttpClient {
    static final byte PROTO_VER5 = 5;
    static final byte CONNECT = 1;
    static final byte NO_AUTH = 0;
    static final byte IPV4 = 1;
    static final byte[] SOCKSV5_VERSION_AUTH = new byte[]{5, 1, 0};
    static final byte[] SOCKSV5_CON = new byte[]{5, 1, 0, 1};
    private ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
    private final HttpClientConfig config;
    private Queue<ClientAtta> pendingConnect = new ConcurrentLinkedQueue<ClientAtta>();
    private long lastTimeoutCheckTime;
    private LinkedList<ClientAtta> clients = new LinkedList();
    private volatile boolean running = true;
    private Selector selector;

    public HttpClient(HttpClientConfig config) throws IOException {
        this.config = config;
        this.selector = Selector.open();
        this.lastTimeoutCheckTime = System.currentTimeMillis();
        SelectorLoopThread thread = new SelectorLoopThread();
        thread.setDaemon(true);
        thread.start();
    }

    private void clearTimeouted(long currentTime) {
        Iterator ite = this.clients.iterator();
        while (ite.hasNext()) {
            ClientAtta client = (ClientAtta)ite.next();
            if (client.finished) {
                ite.remove();
                continue;
            }
            if ((long)this.config.timeOutMs + client.lastActiveTime >= currentTime) continue;
            ite.remove();
            String msg = "read socks server timeout: ";
            switch (client.state) {
                case DIRECT_CONNECTING: {
                    msg = "connect timeout: ";
                    break;
                }
                case SOCKS_CONNECTTING: {
                    msg = "connect socks server timeout: ";
                    break;
                }
                case DIRECT_CONNECTED: {
                    msg = "read timeout: ";
                }
            }
            client.finish(new TimeoutException(msg + this.config.timeOutMs + "ms"));
        }
    }

    private void doRead(SelectionKey key, long currentTime) {
        ClientAtta atta = (ClientAtta)key.attachment();
        try {
            this.buffer.clear();
            int read = ((SocketChannel)key.channel()).read(this.buffer);
            if (read == -1) {
                atta.finish();
            } else if (read > 0) {
                atta.lastActiveTime = currentTime;
                this.buffer.flip();
                switch (atta.state) {
                    case DIRECT_CONNECTED: 
                    case SOCKS_HTTP_REQEUST: {
                        ClientDecoder decoder = atta.decoder;
                        ClientDecoderState state = decoder.decode(this.buffer);
                        if (state == ClientDecoderState.ALL_READ) {
                            atta.finish();
                            break;
                        }
                        if (state != ClientDecoderState.ABORTED) break;
                        atta.finish(new TextRespListener.AbortException());
                        break;
                    }
                    case SOCKS_VERSION_AUTH: {
                        if (read == 2) {
                            atta.state = ClientConnState.SOCKS_INIT_CONN;
                            key.interestOps(4);
                            break;
                        }
                        atta.finish(new SocketException("Malformed reply from SOCKS server"));
                        break;
                    }
                    case SOCKS_INIT_CONN: {
                        if (read == 10 && this.buffer.get(1) == 0) {
                            atta.state = ClientConnState.SOCKS_HTTP_REQEUST;
                            key.interestOps(4);
                            break;
                        }
                        atta.finish(new SocketException("Malformed reply from SOCKS server"));
                    }
                }
            }
        }
        catch (Exception e) {
            atta.finish(e);
        }
    }

    private void doWrite(SelectionKey key) {
        ClientAtta atta = (ClientAtta)key.attachment();
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            switch (atta.state) {
                case DIRECT_CONNECTED: 
                case SOCKS_HTTP_REQEUST: {
                    ByteBuffer request = atta.request;
                    ch.write(request);
                    if (request.hasRemaining()) break;
                    key.interestOps(1);
                    break;
                }
                case SOCKS_VERSION_AUTH: {
                    ByteBuffer versionAuth = ByteBuffer.wrap(SOCKSV5_VERSION_AUTH);
                    ch.write(versionAuth);
                    key.interestOps(1);
                    break;
                }
                case SOCKS_INIT_CONN: {
                    ByteBuffer con = ByteBuffer.allocate(10);
                    con.put(SOCKSV5_CON);
                    con.put(InetAddress.getByName(atta.url.getHost()).getAddress());
                    con.putShort((short)HttpUtils.getPort(atta.url));
                    con.flip();
                    ch.write(con);
                    key.interestOps(1);
                }
            }
        }
        catch (IOException e) {
            atta.finish(e);
        }
    }

    public void get(URI uri, Map<String, String> headers, IRespListener cb) {
        this.get(uri, headers, Proxy.NO_PROXY, cb);
    }

    public String toString() {
        return this.getClass().getCanonicalName() + this.config.toString();
    }

    public void post(URI uri, Map<String, String> headers, Map<String, Object> body, IRespListener cb) {
        this.post(uri, headers, body, Proxy.NO_PROXY, cb);
    }

    public void get(URI uri, Map<String, String> headers, Proxy proxy, IRespListener cb) {
        headers = headers == null ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        this.exec(uri, HttpMethod.GET, headers, null, proxy, cb);
    }

    public void post(URI uri, Map<String, String> headers, Map<String, Object> body, Proxy proxy, IRespListener cb) {
        byte[] data = null;
        headers = headers == null ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        if (body != null) {
            StringBuilder sb = new StringBuilder(32);
            for (Map.Entry<String, Object> e : body.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                try {
                    sb.append(URLEncoder.encode(e.getKey(), "utf8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(e.getValue().toString(), "utf8"));
                }
                catch (UnsupportedEncodingException ignore) {}
            }
            data = sb.toString().getBytes(HttpUtils.UTF_8);
            headers.put("Content-Type", "application/x-www-form-urlencoded");
        }
        this.exec(uri, HttpMethod.POST, headers, data, proxy, cb);
    }

    public void exec(URI uri, HttpMethod method, Map<String, String> headers, byte[] body, Proxy proxy, IRespListener cb) {
        headers = headers == null ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        headers.put("Host", uri.getHost());
        headers.put("Accept", "*/*");
        if (headers.get("User-Agent") == null) {
            headers.put("User-Agent", this.config.userAgent);
        }
        if (!headers.containsKey("Accept-Encoding")) {
            headers.put("Accept-Encoding", "gzip, deflate");
        }
        int length = 64 + headers.size() * 48;
        if (body != null) {
            headers.put("Content-Length", Integer.toString(body.length));
            length += body.length;
        }
        String path = HttpUtils.getPath(uri);
        DynamicBytes bytes = new DynamicBytes(length);
        bytes.append(method.toString()).append((byte)32).append(path).append((byte)32);
        bytes.append("HTTP/1.1").append((byte)13).append((byte)10);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            if (e.getValue() == null) continue;
            bytes.append(e.getKey()).append((byte)58).append((byte)32).append(e.getValue());
            bytes.append((byte)13).append((byte)10);
        }
        bytes.append((byte)13).append((byte)10);
        if (body != null) {
            bytes.append(body, 0, body.length);
        }
        ByteBuffer request = ByteBuffer.wrap(bytes.get(), 0, bytes.length());
        this.pendingConnect.offer(new ClientAtta(request, cb, proxy, uri));
        this.selector.wakeup();
    }

    public static void main(String[] args) {
        System.out.println(HttpMethod.DELETE.toString());
    }

    private void processPendings(long currentTime) {
        try {
            ClientAtta job;
            while ((job = this.pendingConnect.poll()) != null) {
                SocketChannel ch;
                if (job.addr == null) continue;
                job.ch = ch = SocketChannel.open();
                job.lastActiveTime = currentTime;
                ch.configureBlocking(false);
                ch.register(this.selector, 8, job);
                ch.connect(job.addr);
                this.clients.add(job);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void eventLoop() throws IOException {
        while (this.running) {
            int select;
            long currentTime = System.currentTimeMillis();
            this.processPendings(currentTime);
            if (currentTime - this.lastTimeoutCheckTime > 3000L) {
                this.clearTimeouted(currentTime);
                this.lastTimeoutCheckTime = currentTime;
            }
            if ((select = this.selector.select(3000L)) <= 0) continue;
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            for (SelectionKey key : selectedKeys) {
                if (!key.isValid()) continue;
                if (key.isConnectable()) {
                    SocketChannel ch = (SocketChannel)key.channel();
                    try {
                        if (!ch.finishConnect()) continue;
                        ClientAtta attr = (ClientAtta)key.attachment();
                        switch (attr.state) {
                            case SOCKS_CONNECTTING: {
                                attr.state = ClientConnState.SOCKS_VERSION_AUTH;
                                break;
                            }
                            case DIRECT_CONNECTING: {
                                attr.state = ClientConnState.DIRECT_CONNECTED;
                            }
                        }
                        attr.lastActiveTime = currentTime;
                        key.interestOps(4);
                    }
                    catch (IOException e) {
                        ClientAtta attr = (ClientAtta)key.attachment();
                        attr.finish(e);
                    }
                    continue;
                }
                if (key.isWritable()) {
                    this.doWrite(key);
                    continue;
                }
                if (!key.isReadable()) continue;
                this.doRead(key, currentTime);
            }
            selectedKeys.clear();
        }
    }

    public void stop() throws IOException {
        this.running = false;
        if (this.selector != null) {
            this.selector.close();
        }
    }

    private class SelectorLoopThread
    extends Thread {
        private SelectorLoopThread() {
        }

        @Override
        public void run() {
            this.setName("http-client");
            try {
                HttpClient.this.eventLoop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

