/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.client.ClientConnState;
import me.shenfeng.http.client.ClientDecoder;
import me.shenfeng.http.client.IRespListener;

public class ClientAtta {
    InetSocketAddress addr;
    final ClientDecoder decoder;
    final ByteBuffer request;
    long lastActiveTime;
    SocketChannel ch;
    ClientConnState state;
    final URI url;
    boolean finished = false;

    public ClientAtta(ByteBuffer request, IRespListener handler, Proxy proxy, URI url) {
        this.decoder = new ClientDecoder(handler);
        this.url = url;
        this.request = request;
        if (proxy.type() == Proxy.Type.SOCKS) {
            this.state = ClientConnState.SOCKS_CONNECTTING;
            this.addr = (InetSocketAddress)proxy.address();
        } else {
            this.state = ClientConnState.DIRECT_CONNECTING;
            try {
                this.addr = HttpUtils.getServerAddr(url);
            }
            catch (UnknownHostException e) {
                this.decoder.listener.onThrowable(e);
            }
        }
    }

    public void finish() {
        HttpUtils.closeQuiety(this.ch);
        this.finished = true;
        this.decoder.listener.onCompleted();
    }

    public void finish(Throwable t) {
        HttpUtils.closeQuiety(this.ch);
        this.finished = true;
        this.decoder.listener.onThrowable(t);
    }
}

