(ns expectations.platform
  (:refer-clojure :exclude [bound? format ns-name])
  (:require                                  
                                 
           [goog.string]
           [goog.string.format])
                                               )

     
              
                                 

     
                   
             
                                         
                          

     
                 
                                      

(defn ns-name [ns]
                                                      
         (if (symbol? ns) ns))

(def bound?
                           
         (fn [& vars] (every? #(deref %) vars)))

(def format
                           
         goog.string/format)

(defn getenv [var]
                           
         (aget (.-env js/process) var))

(defn get-message [e] (-> e
                                         
                               .-message))

(defn nano-time []
                         
         (-> js/process .hrtime js->clj
           (#(+ (* 1e9 (% 0)) (% 1)))))

(defn on-windows? []
  (re-find #"[Ww]in"
                                        
           (.-platform js/process)))

(def pprint
                     
         println)                                           ;until there's a usable cljs pprint port

(defn print-stack-trace [e]
  (-> e
                          
           .-stack println))

(def iref-types
                         
         #{cljs.core/Atom})

;;;;;;;;;;;; This file autogenerated from src/cljx/expectations/platform.cljx
