(ns expectations.platform
  (:refer-clojure :exclude [bound? format ns-name])
  (:require       [clojure.pprint :as pprint]
                  [cljs.analyzer]
                        
                               )
        (:import (clojure.lang Agent Atom Ref)))

     
(defn cljs? []
  (boolean (find-ns 'cljs.core)))

     
(defn expanding [n]
  (if (cljs?)
    `'~(cljs.analyzer/macroexpand-1 {} n)
    `'~(macroexpand-1 n)))

     
(defn err-type []
  (if (cljs?) `~'js/Error `Throwable))

(defn ns-name [ns]
        (if (symbol? ns) ns (clojure.core/ns-name ns))
                             )

(def bound?
        clojure.core/bound?
                                               )

(def format
        clojure.core/format
                           )

(defn getenv [var]
        (System/getenv var)
                                      )

(defn get-message [e] (-> e
                              .getMessage
                                        ))

(defn nano-time []
        (System/nanoTime)
                                       
                                      )

(defn on-windows? []
  (re-find #"[Ww]in"
          (System/getProperty "os.name")
                                  ))

(def pprint
        pprint/pprint
                )                                           ;until there's a usable cljs pprint port

(defn print-stack-trace [e]
  (-> e
          .printStackTrace
                   println))

(def iref-types
        #{Agent Atom Ref}
                          )

;;;;;;;;;;;; This file autogenerated from src/cljx/expectations/platform.cljx
