(defproject com.taoensso.debug/lein "0.0.1-SNAPSHOT"
  :dependencies [;;[org.clojure/clojure      "1.4.0"]
                 [org.clojure/tools.reader "0.8.5"]

                 ;;; Inclusion fixes:
                 ;; [org.clojure/clojure       "1.6.0"]
                 ;; [org.clojure/clojurescript "0.0-2261"]
                 ]
  :plugins      [[lein-pprint                     "1.1.1"]
                 [lein-ancient                    "0.5.5"]
                 [com.keminglabs/cljx             "0.4.0"]
                 ;; Moving above /cljx fixes:
   
                 [lein-cljsbuild                  "1.0.3"]]
  :profiles
  {:dev
   {:dependencies [[org.clojure/clojure       "1.6.0"]
                   [org.clojure/clojurescript "0.0-2261"]
                   [org.clojure/core.async    "0.1.303.0-886421-alpha"]]
    :plugins [              [com.cemerick/austin             "0.1.4"]]
    }}
  :cljx
  {:builds
   [{:source-paths ["src" "test"] :rules :clj  :output-path "target/classes"}
    {:source-paths ["src" "test"] :rules :cljs :output-path "target/classes"}]}

  :cljsbuild
  {:builds
   [{:id :main
     :source-paths ["src" "test" "target/classes"]
     :compiler     {:output-to "target/main.js"
                    :optimizations :advanced
                    :pretty-print false}}]}

  :prep-tasks [["cljx" "once"] "javac" "compile"]
  :aliases
  {   "build-once" ["do" "cljx" "once," "cljsbuild" "once"]
      "deploy-lib" ["do" "build-once," "deploy" "clojars," "install"]}
  )
