(ns taoensso.carmine.tundra.faraday
  "Faraday (DynamoDB) datastore implementation for Tundra."
  {:author "Peter Taoussanis"}
  (:require [taoensso.faraday       :as far]
            [taoensso.faraday.utils :as futils]
            [taoensso.timbre        :as timbre])
  (:import  [taoensso.carmine.tundra IDataStore]))

(def ttable :faraday.tundra.datastore)

(defn ensure-table
  "Creates the Faraday Tundra table iff it doesn't already exist.

  You'll probably want the minimum write throughput here (1 units) since
  writing will usually occur in tight groups while freezing, and a
  :peak-write-units DataStore option is provided for these periods."
  [creds & [{:keys [throughput block?]}]]
  (far/ensure-table creds ttable [:worker :s]
    {:throughput   throughput
     :range-keydef [:redis-key :s]
     :block?       block?}))

(defrecord FaradayDataStore [creds opts]
  IDataStore
  (put-keys [store content] ; TODO
    ;; partition-all as 16-groups and stitch
    ;; 15 because (< (* 15 64) 1024), so we'll be under 1MB limit even if every
    ;; key is max possible size.

    ;; Return {<k> <success?> ...}

    ;; TODO auto-adjust write throughput up for freezing, and down again after.
    ;; This could be controlled by opts.
    ;;
    ;; Would 1st require tooling support from Faraday since large write-limit
    ;; increases are troublesome (require 2x increments, <= 4 reductions /day).

    )
  (fetch-keys [store ks] ; TODO
    ;; partition-all as 50-groups and stitch

    ;; Doesn't need to be a consistent read since there's presumably been at
    ;; least HOURS since last write :-)

    ;; Return {<k> <frozen-content> ...}

    ))

(defn faraday-datastore [creds & [{:keys [peek-write-units]}]])

(comment ; TODO
  (def creds {:access-key "" :secret-key ""})

  (ensure-table creds {:throughput {:read 1 :write 1}})
  (far/describe-table creds ttable)


  (let [ttable  ttable
        tworker :test-worker
        tkey (partial car/kname "carmine" "tundra" "temp" "test")
        [k1 k2 k3 k4 :as ks] (mapv tkey ["k1 k2 k3 k4"])]

    (wcar (apply car/del ks))
    (far/batch-write-item creds {ttable {:delete [{:worker   (name tworker)
                                                   :redis-key k1}]}})

    (far/scan creds tundra/ttable {:attr-conds {:worker [:eq ["default"]]}})))