/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.logging.Logger;
import net.jini.url.httpmd.HttpmdUtil;
import net.jini.url.httpmd.WrongMessageDigestException;

class MdInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger("net.jini.url.httpmd");
    private static final int SKIP_BUFFER_SIZE = 512;
    private final URL url;
    private final InputStream in;
    private final MessageDigest messageDigest;
    private final byte[] expectedDigest;
    private byte[] skipBuffer;
    private boolean checked;
    private String failed;

    MdInputStream(URL url, InputStream in, MessageDigest messageDigest, byte[] expectedDigest) {
        if (url == null || in == null || messageDigest == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.in = in;
        this.messageDigest = messageDigest;
        this.expectedDigest = (byte[])expectedDigest.clone();
    }

    public synchronized int read() throws IOException {
        this.checkFailed();
        int result = this.in.read();
        if (result < 0) {
            this.checkDigest();
        } else {
            this.messageDigest.update((byte)result);
        }
        return result;
    }

    private void checkFailed() throws WrongMessageDigestException {
        if (this.failed != null) {
            WrongMessageDigestException exception = new WrongMessageDigestException(this.failed);
            logger.log(Levels.FAILED, "Incorrect message digest", exception);
            throw exception;
        }
    }

    private void checkDigest() throws WrongMessageDigestException {
        if (!this.checked) {
            byte[] result = this.messageDigest.digest();
            this.checked = true;
            if (!MessageDigest.isEqual(result, this.expectedDigest)) {
                this.failed = "Incorrect message digest for " + this.url + ": " + HttpmdUtil.digestString(result);
                this.checkFailed();
            }
        }
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkFailed();
        int n = this.in.read(b, off, len);
        if (n < 0) {
            this.checkDigest();
        } else {
            this.messageDigest.update(b, off, n);
        }
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        long remaining;
        int nr;
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[512];
        }
        for (remaining = n; remaining > 0L && (nr = this.read(this.skipBuffer, 0, (int)Math.min(512L, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    public synchronized int available() throws IOException {
        this.checkFailed();
        return this.in.available();
    }

    public synchronized void close() throws IOException {
        this.checkFailed();
        this.in.close();
    }
}

