/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.lease.AbstractLeaseMap;
import java.rmi.RemoteException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMapException;
import net.jini.id.Uuid;

public class LandlordLeaseMap
extends AbstractLeaseMap {
    private final Landlord landlord;
    private final Uuid landlordUuid;

    LandlordLeaseMap(Landlord landlord, Uuid landlordUuid, Lease lease, long duration) {
        super(lease, duration);
        if (landlord == null) {
            throw new NullPointerException("Landlord must be non-null");
        }
        if (landlordUuid == null) {
            throw new NullPointerException("landlordUuid must be non-null");
        }
        this.landlord = landlord;
        this.landlordUuid = landlordUuid;
    }

    public boolean canContainKey(Object key) {
        if (key instanceof LandlordLease) {
            return this.landlordUuid.equals((Object)((LandlordLease)key).landlordUuid());
        }
        return false;
    }

    public void cancelAll() throws LeaseMapException, RemoteException {
        Uuid[] cookies = new Uuid[this.size()];
        LandlordLease[] leases = new LandlordLease[cookies.length];
        Iterator it = this.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            LandlordLease lease;
            leases[i] = lease = (LandlordLease)it.next();
            cookies[i] = lease.cookie();
            ++i;
        }
        Map rslt = this.landlord.cancelAll(cookies);
        if (rslt == null) {
            return;
        }
        int origSize = rslt.size();
        for (int i2 = 0; i2 < cookies.length; ++i2) {
            Object exception = rslt.remove(cookies[i2]);
            if (exception == null) continue;
            rslt.put(leases[i2], exception);
            this.remove(leases[i2]);
        }
        if (origSize != rslt.size()) {
            throw new ConcurrentModificationException();
        }
        throw new LeaseMapException("Failure canceling one or more leases", rslt);
    }

    public void renewAll() throws LeaseMapException, RemoteException {
        Uuid[] cookies = new Uuid[this.size()];
        long[] extensions = new long[cookies.length];
        LandlordLease[] leases = new LandlordLease[cookies.length];
        Iterator it = this.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            LandlordLease lease;
            leases[i] = lease = (LandlordLease)it.next();
            cookies[i] = lease.cookie();
            extensions[i] = (Long)this.get(lease);
            ++i;
        }
        long now = System.currentTimeMillis();
        Landlord.RenewResults results = this.landlord.renewAll(cookies, extensions);
        HashMap<LandlordLease, Exception> bad = null;
        int d = 0;
        for (int i2 = 0; i2 < cookies.length; ++i2) {
            Object badTime;
            if (results.granted[i2] != -1L) {
                long newExp = now + results.granted[i2];
                if (newExp < 0L) {
                    newExp = Long.MAX_VALUE;
                }
                leases[i2].setExpiration(newExp);
                continue;
            }
            if (bad == null) {
                bad = new HashMap<LandlordLease, Exception>(results.denied.length + results.denied.length / 2);
            }
            if ((badTime = this.remove(leases[i2])) == null) {
                throw new ConcurrentModificationException();
            }
            bad.put(leases[i2], results.denied[d++]);
        }
        if (bad != null) {
            throw new LeaseMapException("renewing", bad);
        }
    }

    Landlord landlord() {
        return this.landlord;
    }
}

