/*
 * Decompiled with CFR 0.152.
 */
package com.sumannewton.server.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;

public class DynamicRoleFilter
implements ContainerRequestFilter {
    private final List<String> rolesAllowed;

    public DynamicRoleFilter(String ... rolesAllowed) {
        this(Arrays.asList(rolesAllowed));
    }

    public DynamicRoleFilter(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        MultivaluedMap propertyNames = containerRequestContext.getHeaders();
        propertyNames.putAll((Map)containerRequestContext.getUriInfo().getPathParameters());
        propertyNames.putAll((Map)containerRequestContext.getUriInfo().getQueryParameters());
        SecurityContext securityContext = containerRequestContext.getSecurityContext();
        if (securityContext.getUserPrincipal() != null) {
            if (this.rolesAllowed.stream().map(role -> propertyNames.keySet().stream().filter(role::contains).reduce((String)role, (r1, r2) -> r1.replace(String.format("{%s}", r2), (CharSequence)propertyNames.getFirst(r2)))).anyMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0))) {
                return;
            }
        }
        boolean bl = false;
        boolean authorized = bl;
        if (authorized) return;
        throw new ForbiddenException(LocalizationMessages.USER_NOT_AUTHORIZED());
    }
}

