(ns turvata.keys
  (:require
   [buddy.core.nonce :as nonce]
   [buddy.core.codecs :as codecs]
   [buddy.core.hash :as hash]
   [taoensso.truss :refer [have]]))

(defn- bytes->b64-str [byte-arr]
  (-> byte-arr (codecs/bytes->b64 true) codecs/bytes->str))

(defn hash-token
  "Hash a bearer token for storage in a catalog.

  Security note: this assumes tokens are high-entropy random secrets (e.g.
  generated by `generate-token`), not user-chosen strings."
  [token!!]
  (-> (have string? token!!) hash/sha256 bytes->b64-str))

(defn generate-token
  "Create a new high-entropy token.

  Returns a map with
  - `:token` the token as a string
  - `:hashed` the hashed value to place in the catalog"
  []
  (let [randomdata (nonce/random-bytes 32)
        token      (-> randomdata bytes->b64-str)
        hashed     (hash-token token)]
    {:token!! token
     :hashed hashed}))

(defn ^:deprecated random-token
  "Deprecated name for `generate-token` kept for compatibility."
  []
  (generate-token))
