package com.steammachine.testmachine.sdk;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static com.steammachine.testmachine.sdk.ApiLevel.Level.EXPERIMENTAL;
import static java.lang.annotation.ElementType.TYPE;

@ApiLevel(EXPERIMENTAL)
@Retention(RetentionPolicy.SOURCE)
@Target(value = {TYPE})
public @interface ApiLevel {

    enum Level {
        /**
         * Feature is experimental later can become {@link Level#SUPPORTED} or{@link Level#DEPRECATED}
         */
        EXPERIMENTAL,

        /**
         * Feature is supported later can become {@link Level#DEPRECATED}
         */
        SUPPORTED,

        /**
         * Feature is deprecated later can be deleted
         */
        DEPRECATED
    }

    Level value();


}
