/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.ignore.implementation;

import com.steammachine.org.junit5.extensions.ignore.IgnoreCondition;
import com.steammachine.org.junit5.extensions.ignore.implementation.StatelessConditionCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StatelessConditionCacheIV1
implements StatelessConditionCache {
    private final ConcurrentHashMap<Key, IgnoreCondition> registry = new ConcurrentHashMap();

    public Map<Key, IgnoreCondition> registry() {
        return this.registry;
    }

    @Override
    public <T extends IgnoreCondition> T retrieve(Class<T> clazz, Function<Class<T>, T> function, String ... params) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(function);
        Key compositeKey = new Key(clazz, StatelessConditionCacheIV1.normalizeParams(params));
        return (T)this.registry.computeIfAbsent(compositeKey, key -> (IgnoreCondition)function.apply(key.clazz()));
    }

    @Deprecated
    public <T extends IgnoreCondition> T retrieve(Class<T> clazz, Function<Class<T>, T> function) {
        return this.retrieve(clazz, function, null);
    }

    private static List<String> normalizeParams(String ... params) {
        if (params == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(Arrays.stream(params).filter(s -> s != null).filter(s -> !s.trim().isEmpty()).collect(Collectors.toSet()));
        Collections.sort(result);
        return result;
    }

    private static final class Key<T> {
        private final List<String> params = new ArrayList<String>();
        private final Class<T> clazz;
        private final int hashCode;

        private Key(Class<T> clazz, List<String> params) {
            this.clazz = Objects.requireNonNull(clazz);
            Objects.requireNonNull(params);
            this.params.addAll(params);
            this.hashCode = Key.caleHashCode(this);
        }

        public Class<T> clazz() {
            return this.clazz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.params != null ? !this.params.equals(key.params) : key.params != null) {
                return false;
            }
            return this.clazz != null ? this.clazz.equals(key.clazz) : key.clazz == null;
        }

        public static int caleHashCode(Key key) {
            int result = key.params != null ? key.params.hashCode() : 0;
            result = 31 * result + (key.clazz != null ? key.clazz.hashCode() : 0);
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Key{params=" + this.params + ", clazz=" + this.clazz + '}';
        }
    }
}

