/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.ignore.implementation;

import com.steammachine.common.lazyeval.LazyEval;
import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.common.utils.metodsutils.MethodCaller;
import com.steammachine.common.utils.metodsutils.MethodUtils;
import com.steammachine.org.junit5.extensions.ignore.Cached;
import com.steammachine.org.junit5.extensions.ignore.Ignore;
import com.steammachine.org.junit5.extensions.ignore.IgnoreCondition;
import com.steammachine.org.junit5.extensions.ignore.implementation.StatelessConditionCache;
import com.steammachine.org.junit5.extensions.ignore.implementation.StatelessConditionCacheImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class IgnoreExtensionV6
implements ExecutionCondition {
    public static final int VERSION = 3;
    public static final int SUB_VERSION = 2;
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"");
    private static final StatelessConditionCache cache = new StatelessConditionCacheImpl();
    private static final String NULL_SIGN = "->null";
    private static final String EQUAL_SIGN = "=";

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return this.evaluateIfAnnotated(context);
    }

    private ConditionEvaluationResult evaluateIfAnnotated(ExtensionContext context) {
        Optional disabledOptional = AnnotationUtils.findAnnotation((Optional)context.getElement(), Ignore.class);
        if (!disabledOptional.isPresent()) {
            return ENABLED;
        }
        Object testInstance = context.getTestInstance().orElse(null);
        Ignore i = (Ignore)disabledOptional.get();
        boolean isDisabled = (Boolean)CommonUtils.suppress(() -> IgnoreExtensionV6.getCondition(i.condition(), testInstance, cache, i.params()).evaluate(), Boolean.TYPE);
        String reason = i.value().isEmpty() ? null : "@Ignore with reason --> " + i.value();
        return isDisabled ? ConditionEvaluationResult.disabled(reason) : ENABLED;
    }

    private static <T extends IgnoreCondition> T getCondition(Class<T> value, Object testInstance, StatelessConditionCache cache, String[] settings) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(cache);
        Objects.requireNonNull(settings);
        if (IgnoreExtensionV6.isStateless(value)) {
            return (T)cache.retrieve(value, c -> IgnoreExtensionV6.createClassInstance(c, testInstance, settings), settings);
        }
        return (T)((IgnoreCondition)CommonUtils.suppress(() -> IgnoreExtensionV6.createClassInstance(value, testInstance, settings)));
    }

    private static <T extends IgnoreCondition> T createClassInstance(Class<T> clazz, Object testInstance, String ... settings) {
        Constructor factory;
        boolean useTestInstance;
        if (clazz.getDeclaringClass() == null) {
            Constructor con = Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).map(c -> {
                c.setAccessible(true);
                return c;
            }).findFirst().orElse(null);
            if (con != null) {
                useTestInstance = false;
            } else {
                con = Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0] == testInstance.getClass()).map(c -> {
                    c.setAccessible(true);
                    return c;
                }).findFirst().orElse(null);
                useTestInstance = true;
            }
            if (con == null) {
                throw new IllegalStateException("Class " + clazz + " does not have no-args constructor");
            }
            factory = con;
        } else if (Modifier.isStatic(clazz.getModifiers())) {
            factory = Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).map(c -> {
                c.setAccessible(true);
                return c;
            }).findFirst().orElseThrow(() -> new IllegalStateException("Class " + clazz + " does not have no-args constructor"));
            useTestInstance = false;
        } else {
            Objects.requireNonNull(testInstance);
            factory = Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1 && c.getParameterTypes()[0] == testInstance.getClass()).map(c -> {
                c.setAccessible(true);
                return c;
            }).findFirst().orElseThrow(() -> new IllegalStateException("Class " + clazz + " does not have no-args constructor"));
            useTestInstance = true;
        }
        IgnoreCondition t = (IgnoreCondition)CommonUtils.suppress(() -> useTestInstance ? factory.newInstance(testInstance) : (IgnoreCondition)factory.newInstance(new Object[0]));
        if (settings.length > 0) {
            IgnoreExtensionV6.fillProperties(t, settings);
        }
        return (T)t;
    }

    private static void fillProperties(Object o, String[] settings) {
        class Setter {
            private final MethodCaller caller;
            private final Object object;
            private final Object value;

            Setter(MethodCaller caller, Object object, Object value) {
                this.caller = Objects.requireNonNull(caller);
                this.object = Objects.requireNonNull(object);
                this.value = value;
            }

            private void setVal() {
                this.caller.invoke(this.object, new Object[]{this.value});
            }
        }
        class Parsed {
            private final String name;
            private final String rawValue;
            private final boolean nullValue;

            Parsed(String name, String rawValue, boolean nullValue) {
                this.name = Objects.requireNonNull(name);
                this.rawValue = nullValue ? rawValue : Objects.requireNonNull(rawValue);
                this.nullValue = nullValue;
            }

            public String name() {
                return this.name;
            }

            private String rawValue() {
                return this.rawValue;
            }

            private boolean nullValue() {
                return this.nullValue;
            }
        }
        Objects.requireNonNull(o);
        Objects.requireNonNull(settings);
        LazyEval setters = LazyEval.eval(() -> {
            class Accumulator {
                private final Map<String, List<Method>> methods = new HashMap<String, List<Method>>();

                Accumulator() {
                }

                Accumulator(Method method) {
                    Objects.requireNonNull(method);
                    this.methods.put(method.getName(), Arrays.asList(method));
                }

                public Accumulator merge(Accumulator accumulator) {
                    Accumulator result = new Accumulator();
                    for (Map.Entry<String, List<Method>> entry : this.methods.entrySet()) {
                        result.methods.putIfAbsent(entry.getKey(), new ArrayList());
                        result.methods.get(entry.getKey()).addAll((Collection<Method>)entry.getValue());
                    }
                    for (Map.Entry<String, List<Method>> entry : accumulator.methods.entrySet()) {
                        result.methods.putIfAbsent(entry.getKey(), new ArrayList());
                        result.methods.get(entry.getKey()).addAll((Collection<Method>)entry.getValue());
                    }
                    return result;
                }
            }
            return Stream.of(o.getClass().getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> m.getParameterTypes().length == 1).filter(m -> m.getReturnType() == Void.TYPE).filter(m -> m.getName().startsWith("set")).map(x$0 -> new Accumulator((Method)x$0)).reduce(Accumulator::merge).orElse(new Accumulator()).methods;
        });
        LazyEval allProps = LazyEval.eval(() -> ((Map)setters.value()).values().stream().reduce(Collections.emptyList(), IgnoreExtensionV6::mergeLists).stream().map(m -> {
            String name = m.getName().substring(3);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            return m.getParameterTypes()[0].getTypeName() + " " + name;
        }).collect(Collectors.toList()));
        Arrays.stream(settings).filter(Objects::nonNull).filter(s -> !s.trim().isEmpty()).filter(s -> s.contains(EQUAL_SIGN) || s.contains(NULL_SIGN)).map(s -> {
            if (s.contains(NULL_SIGN)) {
                int indexOf = s.indexOf(NULL_SIGN);
                return new Parsed(s.substring(0, indexOf), null, true);
            }
            if (s.contains(EQUAL_SIGN)) {
                int indexOf = s.indexOf(EQUAL_SIGN);
                return new Parsed(s.substring(0, indexOf), s.substring(indexOf + 1, s.length()), false);
            }
            throw new IllegalStateException("illegal property record " + s);
        }).map(p -> {
            String methodName = "set" + p.name().substring(0, 1).toUpperCase() + p.name().substring(1, p.name().length());
            List methods = (List)((Map)setters.value()).get(methodName);
            if (methods == null) {
                throw new IllegalStateException("property " + p.name() + " not found. Possible properties are " + allProps.value());
            }
            ArrayList<Setter> list = new ArrayList<Setter>();
            for (Method method : methods) {
                if (method.getParameterTypes()[0].isPrimitive() && ((Parsed)p).nullValue()) {
                    throw new IllegalStateException("cannot assign null to property " + p.name() + "  Possible properties are " + allProps.value());
                }
                Object value = ((Parsed)p).nullValue() ? null : IgnoreExtensionV6.convert(method.getParameterTypes()[0], ((Parsed)p).rawValue());
                list.add(new Setter((MethodCaller)new MethodUtils.BaseMethodCaller(method), o, value));
            }
            return list;
        }).reduce(Collections.emptyList(), IgnoreExtensionV6::mergeLists).forEach(rec$ -> ((Setter)rec$).setVal());
    }

    private static boolean isStateless(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Cached annotation = currentClass.getAnnotation(Cached.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return false;
    }

    private static Object convert(Class typeParam, String value) {
        Objects.requireNonNull(typeParam);
        Objects.requireNonNull(value);
        if (typeParam == String.class) {
            return value;
        }
        if (typeParam == Boolean.TYPE) {
            return IgnoreExtensionV6.parseBoolean(value);
        }
        if (typeParam == Boolean.class) {
            return IgnoreExtensionV6.parseBoolean(value);
        }
        if (typeParam == Byte.TYPE) {
            return Byte.parseByte(value);
        }
        if (typeParam == Byte.class) {
            return Byte.parseByte(value);
        }
        if (typeParam == Short.TYPE) {
            return Short.parseShort(value);
        }
        if (typeParam == Short.class) {
            return Short.parseShort(value);
        }
        if (typeParam == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (typeParam == Integer.class) {
            return Integer.parseInt(value);
        }
        if (typeParam == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (typeParam == Long.class) {
            return Long.parseLong(value);
        }
        if (typeParam == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (typeParam == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (typeParam == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (typeParam == Double.class) {
            return Double.parseDouble(value);
        }
        if (typeParam == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (typeParam == BigInteger.class) {
            return new BigInteger(value);
        }
        throw new IllegalStateException("type " + typeParam + " is not supported");
    }

    private static boolean parseBoolean(String value) {
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        throw new IllegalStateException(" " + value + " is not valid boolean value");
    }

    private static <T> List<T> mergeLists(List<T> l1, List<T> l2) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(l1);
        list.addAll(l2);
        return list;
    }
}

