/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.expectedexceptions;

import com.steammachine.org.junit5.extensions.expectedexceptions.Expected;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.NamespaceFactory;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.util.AnnotationUtils;

class ExpectedExceptionsExtension
implements TestExecutionExceptionHandler,
AfterTestExecutionCallback {
    private final ExtensionContext.Namespace extensionNameSpace = NamespaceFactory.createNameSpace("expected exceptions extension namespace", new Object());

    ExpectedExceptionsExtension() {
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (ExpectedExceptionsExtension.getExpected(context) == null) {
            return;
        }
        context.getStore(this.extensionNameSpace).put(context.getTestMethod().orElseThrow(IllegalStateException::new), (Object)throwable);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        Class<?> throwableClass;
        Expected expected = ExpectedExceptionsExtension.getExpected(context);
        if (expected == null) {
            return;
        }
        Throwable throwable = (Throwable)context.getStore(this.extensionNameSpace).remove(context.getTestMethod().orElseThrow(IllegalStateException::new));
        Class<?> clazz = throwableClass = throwable == null ? null : throwable.getClass();
        if (ExpectedExceptionsExtension.matches(throwableClass, Arrays.asList(expected.expected()), expected.matchExactType())) {
            return;
        }
        String throwableClassName = throwableClass != null ? throwableClass.getName() : null;
        throw new AssertionError((Object)("thrown exception [" + throwableClassName + "] must match one of the following:  " + Stream.of(expected.expected()).filter(Objects::nonNull).map(Class::getName).collect(Collectors.toList())));
    }

    private static Expected getExpected(ExtensionContext context) {
        Optional element = context.getElement();
        if (!element.isPresent()) {
            return null;
        }
        Optional opAnnotation = AnnotationUtils.findAnnotation((Optional)element, Expected.class);
        return opAnnotation.orElse(null);
    }

    static boolean matches(Class<? extends Throwable> thr, List<Class<? extends Throwable>> exp, boolean matchExactType) {
        Objects.requireNonNull(exp, "exp is null");
        exp.forEach(Objects::requireNonNull);
        if (thr == null) {
            return exp.isEmpty();
        }
        return exp.stream().map(Objects::requireNonNull).collect(Collectors.toSet()).stream().anyMatch(i -> ExpectedExceptionsExtension.isRightClass(thr, i, matchExactType));
    }

    private static boolean isRightClass(Class<? extends Throwable> thr, Class<? extends Throwable> exp, boolean matchExactType) {
        if (matchExactType) {
            return exp == thr;
        }
        return exp.isAssignableFrom(thr);
    }
}

