/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.org.junit5.extensions.dynamictests.dynamictestparam;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;

public class DynamicTestParams<T> {
    private static final boolean DEFAULT_CHECKNAME_UNIQUINESS = true;
    public static final Predicate ALWAYS_TRUE = t -> true;
    private List<TestGroup<T>> testGroups = new ArrayList<TestGroup<T>>();
    private List<Supplier<Stream<T>>> generators = new ArrayList<Supplier<Stream<T>>>();
    private boolean checkTestNamesUniquiness = true;
    private volatile boolean locked;

    public static <T> Predicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    private DynamicTestParams() {
    }

    private DynamicTestParams(List<Supplier<Stream<T>>> generators) {
        this.generators.addAll(generators);
    }

    public static <T> BiFunction<String, T, DynamicTest> test(Function<T, Executable> transform) {
        return (s, t) -> DynamicTest.dynamicTest((String)s, (Executable)((Executable)transform.apply(t)));
    }

    public static <T> DynamicTestParams<T> of(T ... params) {
        return new DynamicTestParams<T>().params(params);
    }

    public static <T> DynamicTestParams<T> ofType(Class<T> type) {
        return new DynamicTestParams<Object>().params(new Object[0]);
    }

    public static <T> DynamicTestParams<T> create(Class<T> type) {
        return new DynamicTestParams<Object>().params(new Object[0]);
    }

    public DynamicTestParams<T> param(T param) {
        this.checkLocked(false);
        this.generators.add(() -> Stream.of(param));
        return this;
    }

    public DynamicTestParams<T> generator(Supplier<Stream<T>> generator) {
        this.checkLocked(false);
        Objects.requireNonNull(generator);
        this.generators.add(generator);
        return this;
    }

    @SafeVarargs
    public final DynamicTestParams<T> params(T ... params) {
        this.checkLocked(false);
        Objects.requireNonNull(params);
        Stream.of(params).forEachOrdered(this::param);
        return this;
    }

    public DynamicTestParams<T> checkTestNamesUniquiness(boolean checkTestNamesUniquiness) {
        this.checkLocked(false);
        this.checkTestNamesUniquiness = checkTestNamesUniquiness;
        return this;
    }

    public DynamicTestParams<T> lock() {
        this.locked = true;
        return this;
    }

    public Stream<T> paramsData() {
        return this.generators.stream().flatMap(Supplier::get);
    }

    @Deprecated
    public Stream<DynamicTest> dynamicTests(Function<T, String> name, Function<T, Executable> executableFactory, BiFunction<String, Executable, DynamicTest> testFactory, Predicate<? super T> paramFilter) {
        this.checkLocked(true);
        Objects.requireNonNull(name);
        Objects.requireNonNull(executableFactory);
        Objects.requireNonNull(paramFilter);
        Objects.requireNonNull(testFactory);
        return this.dynamicTests(t -> (DynamicTest)testFactory.apply((String)name.apply(t), (Executable)executableFactory.apply(t)), paramFilter);
    }

    @Deprecated
    public Stream<DynamicTest> dynamicTests(Function<T, DynamicTest> function, Predicate<? super T> predicate) {
        this.checkLocked(true);
        Objects.requireNonNull(function);
        Objects.requireNonNull(predicate);
        if (this.checkTestNamesUniquiness) {
            this.paramsData().filter(predicate).map(function).collect(Collectors.toMap(DynamicNode::getDisplayName, dt -> dt, DynamicTestParams::checkNameUniquiness));
        }
        return this.paramsData().filter(predicate).map(function);
    }

    @Deprecated
    public Stream<DynamicTest> dynamicTests(Function<T, DynamicTest> function) {
        return this.dynamicTests(function, DynamicTestParams.alwaysTrue());
    }

    public DynamicTestParams<T> testGroup(String groupName, BiFunction<String, T, String> nameFactory, BiFunction<String, T, DynamicTest> executableFactory, Predicate<T> paramFilter) {
        this.checkLocked(false);
        if (this.testGroups.stream().map(TestGroup::groupName).anyMatch(s -> Objects.equals(groupName, s))) {
            throw new IllegalStateException();
        }
        this.testGroups.add(new TestGroup(groupName, nameFactory, executableFactory, paramFilter));
        return this;
    }

    public Stream<DynamicTest> form() {
        this.checkLocked(true);
        if (this.checkTestNamesUniquiness) {
            this.createTestStream().map(DynamicNode::getDisplayName).collect(Collectors.toMap(s -> s, s -> s, DynamicTestParams::checkNameUniquiness));
        }
        return this.createTestStream();
    }

    public DynamicTestParams<T> copyParams() {
        this.checkLocked(true);
        return new DynamicTestParams<T>(this.generators);
    }

    private Stream<DynamicTest> createTestStream() {
        return Stream.of(this.getDynamicsTestStream()).flatMap(Supplier::get);
    }

    private Supplier<Stream<DynamicTest>> getDynamicsTestStream() {
        return () -> this.testGroups.stream().flatMap(group -> this.generators.stream().flatMap(Supplier::get).filter(group.paramFilter()).map(t -> group.executableFactory().apply(group.nameFactory().apply(group.groupName(), t), t)));
    }

    private static DynamicTest checkNameUniquiness(DynamicTest dt, DynamicTest dt2) {
        if (dt != dt2 && Objects.equals(dt.getDisplayName(), dt2.getDisplayName())) {
            throw new IllegalStateException("test nameFactory " + dt.getDisplayName() + " is already in use");
        }
        return dt;
    }

    private static String checkNameUniquiness(String dt, String dt2) {
        if (Objects.equals(dt, dt2)) {
            throw new IllegalStateException("name " + dt + " is already in use");
        }
        return dt;
    }

    private void checkLocked(boolean value) {
        if (this.locked != value) {
            throw new IllegalStateException("locked value " + this.locked + " does not match to expected " + value);
        }
    }

    private static <T> Stream<T> streamFromIterable(Supplier<Iterable<T>> iterableSupplier) {
        Iterator<T> iterator = iterableSupplier.get().iterator();
        Stream.Builder<T> builder = Stream.builder();
        while (iterator.hasNext()) {
            builder.accept(iterator.next());
        }
        return builder.build();
    }

    private static <T> Supplier<Iterable<T>> fromFunctionGenerator(Function<Integer, T> generator) {
        Objects.requireNonNull(generator);
        return () -> () -> DynamicTestParams.functionGeneratorIterator(generator);
    }

    private static <T> Iterator<T> functionGeneratorIterator(Function<Integer, T> generator) {
        return new FunctionGeneratorIterator(generator);
    }

    private static class FunctionGeneratorIterator<T>
    implements Iterator<T> {
        private final Function<Integer, T> generator;
        private volatile T next;
        private volatile int index = -1;

        private FunctionGeneratorIterator(Function<Integer, T> generator) {
            this.generator = Objects.requireNonNull(generator);
        }

        @Override
        public boolean hasNext() {
            if (this.index == -1) {
                this.index = 0;
                this.next = this.generator.apply(this.index);
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T curNext = this.next;
            this.next = this.generator.apply(++this.index);
            return curNext;
        }
    }

    private static final class TestGroup<G> {
        private final String groupName;
        private final BiFunction<String, G, String> nameFactory;
        private final BiFunction<String, G, DynamicTest> executableFactory;
        private final Predicate<G> paramFilter;

        private TestGroup(String groupName, BiFunction<String, G, String> nameFactory, BiFunction<String, G, DynamicTest> executableFactory, Predicate<G> paramFilter) {
            this.groupName = Objects.requireNonNull(groupName);
            this.nameFactory = Objects.requireNonNull(nameFactory);
            this.executableFactory = Objects.requireNonNull(executableFactory);
            this.paramFilter = Objects.requireNonNull(paramFilter);
        }

        public String groupName() {
            return this.groupName;
        }

        public BiFunction<String, G, String> nameFactory() {
            return this.nameFactory;
        }

        public BiFunction<String, G, DynamicTest> executableFactory() {
            return this.executableFactory;
        }

        public Predicate<G> paramFilter() {
            return this.paramFilter;
        }
    }
}

