/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.flatter2;

import com.steammachine.jsonchecker.impl.flatter2.ValueKey;
import com.steammachine.jsonchecker.types.Path;
import java.util.Objects;
import java.util.Optional;

public class ValRec {
    private final Object value;
    private final Path path;
    private final ValueKey valueKey;

    private ValRec(Path path, ValueKey valueKey, Object value) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(valueKey);
        this.path = Objects.requireNonNull(path);
        this.valueKey = Objects.requireNonNull(valueKey);
        this.value = value;
    }

    public static ValRec of(Path path, ValueKey valueKey, Object value) {
        return new ValRec(path, valueKey, value);
    }

    public ValueKey valueKey() {
        return this.valueKey;
    }

    public Path path() {
        return this.path;
    }

    public ValRec updatePath(Path path) {
        Objects.requireNonNull(path);
        return new ValRec(path, this.valueKey, this.value);
    }

    public Object value() {
        return this.value;
    }

    public Optional<Object> optional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValRec)) {
            return false;
        }
        ValRec valRec = (ValRec)o;
        if (this.value != null ? !this.value.equals(valRec.value) : valRec.value != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(valRec.path) : valRec.path != null) {
            return false;
        }
        return this.valueKey != null ? this.valueKey.equals(valRec.valueKey) : valRec.valueKey == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.valueKey != null ? this.valueKey.hashCode() : 0);
        return result;
    }
}

