/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.directcomparison.flatterprocs;

import com.steammachine.jsonchecker.impl.directcomparison.flatterprocs.FlattersCommon;
import com.steammachine.jsonchecker.impl.flatter2.Id;
import com.steammachine.jsonchecker.impl.flatter2.ValRec;
import com.steammachine.jsonchecker.impl.flatter2.ValueKey;
import com.steammachine.jsonchecker.types.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MonkeyIdFlatter {
    private final String initialKind;

    protected MonkeyIdFlatter(String initialKind) {
        this.initialKind = Objects.requireNonNull(initialKind);
    }

    public static List<ValRec> flattenJSonObject(JSONObject o) {
        ArrayList<ValRec> values = new ArrayList<ValRec>();
        MonkeyIdFlatter monkeyIdFlatter = new MonkeyIdFlatter("");
        monkeyIdFlatter.flattenObject(Path.of().del(), o, values);
        return values.stream().filter(v -> v.path().isPassable()).collect(Collectors.toList());
    }

    protected final void flattenObject(Path parentPath, JSONObject o, List<ValRec> values) {
        Path nextPath;
        Objects.requireNonNull(parentPath);
        Objects.requireNonNull(o);
        Objects.requireNonNull(values);
        String monkeyIdName = this.monkeyIdName(o);
        String componentTypeName = this.componentTypeName(o);
        if (monkeyIdName == null && componentTypeName == null) {
            nextPath = parentPath.notPassable().del();
        } else {
            nextPath = parentPath;
            if (monkeyIdName != null) {
                nextPath = nextPath.addId(Id.obj(monkeyIdName));
            }
            if (componentTypeName != null) {
                nextPath = nextPath.addId(Id.obj(componentTypeName));
            }
            nextPath = nextPath.del();
        }
        for (Map.Entry<String, Object> entry : FlattersCommon.castToEntrySet(o.entrySet())) {
            if (FlattersCommon.isFlatValue(entry.getValue())) {
                values.add(ValRec.of(nextPath.id(Id.obj(entry.getKey())).path(), ValueKey.of((Object)o, entry.getKey()), entry.getValue()));
                continue;
            }
            if (!JSONArray.class.isAssignableFrom(Objects.requireNonNull(entry.getValue()).getClass())) continue;
            this.flattenArrayCommon(nextPath, entry.getKey(), (JSONArray)FlattersCommon.cast(FlattersCommon.cast(entry.getValue())), values);
        }
    }

    private void flattenArrayCommon(Path parentPath, String arrayName, JSONArray array, List<ValRec> values) {
        if ("children".equals(arrayName)) {
            this.flattenChildren(parentPath, array, values);
        } else {
            this.flattenArray(parentPath.id(Id.obj(arrayName)).del(), array, values);
        }
    }

    private void flattenChildren(Path parentPath, JSONArray array, List<ValRec> values) {
        Objects.requireNonNull(parentPath);
        Objects.requireNonNull(array);
        Objects.requireNonNull(values);
        JSONArray list = array;
        for (int index = 0; index < list.size(); ++index) {
            Path nextPath;
            Object item = Objects.requireNonNull(list.get(index));
            if (FlattersCommon.isFlatValue(item)) {
                values.add(ValRec.of(parentPath.id(Id.arr(index)).path(), ValueKey.of((Object)array, index), item));
                continue;
            }
            if (JSONObject.class.isAssignableFrom(item.getClass())) {
                this.flattenObject(parentPath, (JSONObject)FlattersCommon.cast(item), values);
                continue;
            }
            if (!JSONArray.class.isAssignableFrom(item.getClass())) continue;
            String monkeyIdName = this.monkeyIdName((JSONObject)FlattersCommon.cast(item));
            String componentTypeName = this.componentTypeName((JSONObject)FlattersCommon.cast(item));
            if (monkeyIdName == null && componentTypeName == null) {
                nextPath = parentPath.notPassable().del();
            } else {
                nextPath = parentPath;
                nextPath = monkeyIdName != null ? nextPath.addId(Id.obj(monkeyIdName)) : nextPath.notPassable();
                nextPath = componentTypeName != null ? nextPath.addId(Id.obj(componentTypeName)) : nextPath.notPassable();
                nextPath = nextPath.del();
            }
            this.flattenArrayCommon(nextPath, null, (JSONArray)FlattersCommon.cast(item), values);
        }
    }

    private void flattenArray(Path arrayPath, JSONArray array, List<ValRec> values) {
        Objects.requireNonNull(arrayPath);
        Objects.requireNonNull(array);
        Objects.requireNonNull(values);
        JSONArray objects = array;
        for (int index = 0; index < objects.size(); ++index) {
            Object value = objects.get(index);
            if (FlattersCommon.isFlatValue(value)) {
                values.add(ValRec.of(arrayPath.id(Id.arr(index)).path(), ValueKey.of((Object)array, index), value));
                continue;
            }
            if (JSONObject.class.isAssignableFrom(Objects.requireNonNull(value).getClass())) {
                this.flattenObject(arrayPath.id(Id.arr(index)).path().del(), (JSONObject)FlattersCommon.cast(value), values);
                continue;
            }
            if (!JSONArray.class.isAssignableFrom(Objects.requireNonNull(value).getClass())) continue;
            this.flattenArray(arrayPath.id(Id.arr(index)).path().del(), (JSONArray)FlattersCommon.cast(value), values);
        }
    }

    protected String monkeyIdName(JSONObject object) {
        if (object.get((Object)"monkeyId") instanceof String) {
            return (String)object.get((Object)"monkeyId");
        }
        return null;
    }

    protected String componentTypeName(JSONObject object) {
        if (object.get((Object)"ComponentType") instanceof String) {
            return "@" + FlattersCommon.cast(object.get((Object)"ComponentType"));
        }
        return null;
    }
}

