/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.defaults.AddressType;
import com.steammachine.jsonchecker.defaults.MonkeyPathRepresentation;
import com.steammachine.jsonchecker.defaults.ResultNodeCheckContext;
import com.steammachine.jsonchecker.impl.directcomparison.flatterprocs.Flatters;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.Formats;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.PathFormat;
import com.steammachine.jsonchecker.impl.flatter2.Element;
import com.steammachine.jsonchecker.impl.flatter2.Id;
import com.steammachine.jsonchecker.impl.flatter2.IdentifierType;
import com.steammachine.jsonchecker.impl.flatter2.PathCluster;
import com.steammachine.jsonchecker.types.DirectValue;
import com.steammachine.jsonchecker.types.JSONParam;
import com.steammachine.jsonchecker.types.JSONParams;
import com.steammachine.jsonchecker.types.JSONParamsStub;
import com.steammachine.jsonchecker.types.NodeCheckContext;
import com.steammachine.jsonchecker.types.NodeCheckResult;
import com.steammachine.jsonchecker.types.Path;
import com.steammachine.jsonchecker.types.PathParticle;
import com.steammachine.jsonchecker.types.PathRepresentation;
import com.steammachine.jsonchecker.types.exceptions.ParamNotFound;
import com.steammachine.jsonchecker.types.exceptions.WrongDataFormat;
import com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2.CompatibleTypesComparatorV2;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSonDirectComparator {
    private static final String START_PARAM = "${";
    private static final String END_PARAM = "}";
    private static final String VALUES_BY_PATH = "values by path";
    private static final String PARAM_NOT_FOUND = "Param %s not found";

    private JSonDirectComparator() {
    }

    private static String extractParamName(String stringVal) {
        return stringVal.substring(START_PARAM.length(), stringVal.length() - END_PARAM.length());
    }

    private static boolean hasParam(String stringVal) {
        return stringVal.startsWith(START_PARAM) && stringVal.endsWith(END_PARAM);
    }

    public static boolean compareJSonStrings(String json1, String json2, PathRepresentation representation) {
        Objects.requireNonNull(json1);
        Objects.requireNonNull(json2);
        return JSonDirectComparator.compareJSonsObjects(JSonDirectComparator.loadJson(json1), JSonDirectComparator.loadJson(json2), representation).isSuccessful();
    }

    private static NodeCheckResult jsonStreamComparison(InputStream json1, InputStream json2, PathRepresentation representation) throws IOException {
        Objects.requireNonNull(json1);
        Objects.requireNonNull(json2);
        return JSonDirectComparator.compareJSonsObjects(JSonDirectComparator.loadJson(json1), JSonDirectComparator.loadJson(json2), representation);
    }

    public static boolean compareJSonStreams(InputStream json1, InputStream json2, PathRepresentation representation) throws IOException {
        Objects.requireNonNull(json1);
        Objects.requireNonNull(json2);
        return JSonDirectComparator.jsonStreamComparison(json1, json2, representation).isSuccessful();
    }

    public static NodeCheckResult compareJSonsObjects(JSONObject o1, JSONObject o2, PathRepresentation representation) {
        return JSonDirectComparator.compareJSonsObjects(o1, o2, representation, Collections.emptyList());
    }

    public static NodeCheckResult compareJSonsObjects(JSONObject o1, JSONObject o2, PathRepresentation representation, JSONParams params, Collection<String> inclusionsTemplate, Collection<String> exclusionsTemplate) {
        ResultNodeCheckContext result = new ResultNodeCheckContext();
        JSonDirectComparator.doCompareJSonsObjects(o1, o2, params == null ? JSONParamsStub.STUB_PARAMS : params, inclusionsTemplate, exclusionsTemplate, result, representation);
        return result;
    }

    @SafeVarargs
    public static NodeCheckResult compareJSonsObjects(JSONObject o1, JSONObject o2, PathRepresentation representation, Collection<String> ... exclusions) {
        return JSonDirectComparator.compareJSonsObjects(o1, o2, representation, null, null, JSonDirectComparator.uniteCollections(exclusions));
    }

    public static PathCluster parseCluster(String item) {
        String kind = Formats.formatType(item);
        PathFormat pathFormat = Formats.format(kind);
        return PathCluster.of(null, null).putPath(kind, pathFormat.parsePath(item));
    }

    public static JSONObject loadJson(InputStream jsonData) {
        Objects.requireNonNull(jsonData);
        try {
            return (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(jsonData));
        }
        catch (ParseException e) {
            throw new WrongDataFormat(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @SafeVarargs
    public static <T> Collection<T> uniteCollections(Collection<T> ... collections) {
        return Stream.of(collections).filter(Objects::nonNull).map(ts -> ts != null ? ts : Collections.emptyList()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<Map.Entry<String, Object>> castToEntrySet(Object o) {
        return (Set)o;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }

    private static <T> T cast(Object obj, Class<T> clazz) {
        return (T)obj;
    }

    private static void doCompareJSonsObjects(JSONObject o1, JSONObject o2, JSONParams params, Collection<String> inclusion, Collection<String> exclusion, NodeCheckContext context, PathRepresentation representation) {
        Objects.requireNonNull(o1);
        Objects.requireNonNull(o2);
        Objects.requireNonNull(context);
        Objects.requireNonNull(params);
        Collection<PathCluster> inclusions = inclusion == null ? null : JSonDirectComparator.parseTemplate(inclusion);
        Collection<PathCluster> exclusions = exclusion == null ? null : JSonDirectComparator.parseTemplate(exclusion);
        Map<Path, PathCluster> objects1 = JSonDirectComparator.filter(JSonDirectComparator.pathClusters(o1), params, inclusions, exclusions).stream().collect(Collectors.toMap(pc -> pc.path(AddressType.DIRECT.name()), i -> i));
        Map<Path, PathCluster> objects2 = JSonDirectComparator.filter(JSonDirectComparator.pathClusters(o2), params, inclusions, exclusions).stream().collect(Collectors.toMap(pc -> pc.path(AddressType.DIRECT.name()), i -> i));
        objects1.entrySet().stream().map(o -> o).forEach(entry1 -> {
            if (!objects2.containsKey(entry1.getKey())) {
                context.log("value by path " + JSonDirectComparator.stringRep((PathCluster)entry1.getValue(), (Path)entry1.getKey(), representation) + " not found in document 2");
                context.failed();
            }
        });
        objects2.entrySet().stream().map(o -> o).forEach(entry2 -> {
            if (!objects1.containsKey(entry2.getKey())) {
                context.log("value by path " + JSonDirectComparator.stringRep((PathCluster)entry2.getValue(), (Path)entry2.getKey(), representation) + " not found in document 1");
                context.failed();
            }
        });
        Collection commonPaths = CommonUtils.intersectCollections((Collection[])new Collection[]{objects1.keySet(), objects2.keySet()});
        commonPaths.stream().map(i -> new Values((Path)i, (PathCluster)objects1.get(i), (PathCluster)objects2.get(i), ((PathCluster)objects1.get(i)).value(), null, ((PathCluster)objects2.get(i)).value(), null)).map(i -> ((Values)i).applyParams(params)).forEach(vs -> JSonDirectComparator.compareValues(vs, context, representation));
    }

    private static Collection<PathCluster> parseTemplate(Collection<String> items) {
        Objects.requireNonNull(items);
        return items.stream().peek(Objects::requireNonNull).map(JSonDirectComparator::parseCluster).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<PathCluster> filter(List<PathCluster> clusters, JSONParams params, Collection<PathCluster> inclusions, Collection<PathCluster> exclusions) {
        Objects.requireNonNull(clusters);
        return clusters.stream().map(cluster -> JSonDirectComparator.transformCluster(cluster, params)).filter(i -> JSonDirectComparator.inclusionFilter(i, inclusions)).filter(i -> JSonDirectComparator.exclusionFilter(i, exclusions)).collect(Collectors.toList());
    }

    private static PathCluster transformCluster(PathCluster cluster, JSONParams params) {
        boolean hasParams = cluster.kinds().stream().map(cluster::path).flatMap(path -> path.elements().stream()).flatMap(element -> element.list().stream()).map(Id::id).filter(Objects::nonNull).peek(value -> JSonDirectComparator.checkParam(value, params)).anyMatch(JSonDirectComparator::hasParam);
        if (!hasParams) {
            return cluster;
        }
        HashMap<String, Path> modified = new HashMap<String, Path>();
        for (Map.Entry<String, Path> entry : cluster.unmodifiablePathMap().entrySet()) {
            Path.Builder builder = Path.builder();
            block7: for (PathParticle particle : entry.getValue().particles()) {
                switch (particle.type()) {
                    case ANYELEMENT: {
                        builder.ast();
                        continue block7;
                    }
                    case DELIMETR: {
                        builder.del();
                        continue block7;
                    }
                    case NO_TRESPASING: {
                        builder.noTrespassing();
                        continue block7;
                    }
                    case ELEMENT: {
                        Element modifiedElement = Element.empty();
                        Iterator<Id> iterator = ((Element)Element.class.cast(particle)).list().iterator();
                        while (iterator.hasNext()) {
                            Id id;
                            Id modifiedId = id = iterator.next();
                            if (id.type().in(IdentifierType.notArrayItem) && JSonDirectComparator.hasParam(id.id())) {
                                modifiedId = Id.obj((String)String.class.cast(((DirectValue)DirectValue.class.cast(params.get(JSonDirectComparator.extractParamName(id.id())))).value()));
                            }
                            modifiedElement = modifiedElement.addId(modifiedId);
                        }
                        builder.rawElement(modifiedElement);
                        continue block7;
                    }
                }
                throw new IllegalStateException("unknown particle type " + (Object)((Object)particle.type()));
            }
            modified.put(entry.getKey(), builder.get());
        }
        return new PathCluster(cluster.valueKey(), cluster.value(), modified);
    }

    private static void checkParam(String value, JSONParams params) {
        if (!JSonDirectComparator.hasParam(value)) {
            return;
        }
        String paramName = JSonDirectComparator.extractParamName(value);
        CommonUtils.check(() -> DirectValue.class.isInstance(params.get(paramName)), () -> new IllegalStateException("param " + paramName + " must support " + DirectValue.class.getName()));
        CommonUtils.check(() -> String.class.isInstance(((DirectValue)DirectValue.class.cast(params.get(paramName))).value()), () -> new IllegalStateException("param " + paramName + " must be of " + DirectValue.class.getName() + " type"));
    }

    private static boolean exclusionFilter(PathCluster path, Collection<PathCluster> exclusions) {
        return exclusions == null || exclusions.stream().noneMatch(exc -> JSonDirectComparator.isApplied(path, exc));
    }

    private static boolean inclusionFilter(PathCluster path, Collection<PathCluster> inclusions) {
        return inclusions == null || inclusions.stream().anyMatch(exc -> JSonDirectComparator.isApplied(path, exc));
    }

    private static boolean isApplied(PathCluster path, PathCluster template) {
        Objects.requireNonNull(template);
        Objects.requireNonNull(path);
        boolean result = false;
        for (String kind : CommonUtils.intersectCollections((Collection[])new Collection[]{path.kinds(), template.kinds()})) {
            result = result || Formats.isApplied(kind, path.path(kind), template.path(kind));
        }
        return result;
    }

    private static void compareValues(Values vs, NodeCheckContext context, PathRepresentation representation) {
        if (vs.value1() == null && vs.param1() == null && vs.value2() != null) {
            context.log(VALUES_BY_PATH, " ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " are not equal. " + vs.value1() + " != " + vs.value2());
            context.failed();
        } else if (vs.value1() != null && vs.value2() == null && vs.param2() == null) {
            context.log(VALUES_BY_PATH, " ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " are not equal. " + vs.value1() + " != " + vs.value2());
            context.failed();
        } else if (vs.param1() != null && vs.param2() != null && !JSonDirectComparator.compareParams(vs.param1(), vs.param2())) {
            context.log("values with params by path ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " do not match. " + vs.param1().paramsRep() + " and " + vs.param2().paramsRep());
            context.failed();
        } else if (vs.param1() == null && vs.param2() == null && vs.value1() != null && vs.value2() != null && !CompatibleTypesComparatorV2.objectTypesCompatible(vs.value1(), vs.value2())) {
            context.log(VALUES_BY_PATH, " ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " have incompatible types. " + vs.value1().getClass().getName() + " and " + vs.value2().getClass().getName());
            context.failed();
        } else if (vs.param1() == null && vs.param2() == null && !CompatibleTypesComparatorV2.compatibleEquals(vs.value1(), vs.value2())) {
            context.log(VALUES_BY_PATH, " ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " are not equal. " + vs.value1() + " != " + vs.value2());
            context.failed();
        } else if (vs.param1() == null && vs.param2() != null && !vs.param2().matches(vs.value1())) {
            context.log(VALUES_BY_PATH, " ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " do not match. " + vs.value1() + " does not match " + vs.param2().paramsRep());
            context.failed();
        } else if (vs.param1() != null && vs.param2() == null && !vs.param1().matches(vs.value2())) {
            context.log(VALUES_BY_PATH, " ", JSonDirectComparator.stringRep(vs.cluster1(), vs.keyPath(), representation), " do not match. " + vs.value2() + " does not match " + vs.param1().paramsRep());
            context.failed();
        }
    }

    private static boolean compareParams(JSONParam param, JSONParam param2) {
        return param.matchesParam(param2) || param2.matchesParam(param);
    }

    private static String stringRep(PathCluster pathCluster, Path keyPath, PathRepresentation representation) {
        Path path = pathCluster.path(AddressType.MONKEY.name());
        if (path != null) {
            return representation.path(path);
        }
        return representation.path(keyPath);
    }

    private static List<PathCluster> pathClusters(JSONObject object) {
        List monkeyIdCompType = Flatters.flatten(AddressType.MONKEY.name(), object).stream().map(vr -> PathCluster.of(vr.valueKey(), vr.value()).putPath(AddressType.MONKEY.name(), vr.path())).collect(Collectors.toList());
        List direct = Flatters.flatten(AddressType.DIRECT.name(), object).stream().map(vr -> PathCluster.of(vr.valueKey(), vr.value()).putPath(AddressType.DIRECT.name(), vr.path())).collect(Collectors.toList());
        ArrayList clusters = new ArrayList();
        clusters.addAll(monkeyIdCompType);
        clusters.addAll(direct);
        return new ArrayList<PathCluster>(clusters.stream().collect(Collectors.toMap(PathCluster::valueKey, cl -> cl, (cl, cl2) -> PathCluster.merge(cl, cl2))).values());
    }

    private static JSONObject loadJson(String jsonData) {
        Objects.requireNonNull(jsonData);
        try {
            return (JSONObject)new JSONParser().parse(jsonData);
        }
        catch (ParseException e) {
            throw new WrongDataFormat(e);
        }
    }

    public static boolean compareJSonStrings(String json1, String json2) {
        Objects.requireNonNull(json1);
        Objects.requireNonNull(json2);
        return JSonDirectComparator.compareJSonsObjects(JSonDirectComparator.loadJson(json1), JSonDirectComparator.loadJson(json2), MonkeyPathRepresentation.REPRESENTATION).isSuccessful();
    }

    public static boolean compareJSonStreams(InputStream json1, InputStream json2) throws IOException {
        Objects.requireNonNull(json1);
        Objects.requireNonNull(json2);
        return JSonDirectComparator.compareJSonStreams(json1, json2, MonkeyPathRepresentation.REPRESENTATION);
    }

    public static NodeCheckResult compareJSonStreams(InputStream json1, InputStream json2, JSONParams jsonParams, Collection<String> inclusionsTemplate, Collection<String> exclusionsTemplate) {
        return JSonDirectComparator.compareJSonsObjects(JSonDirectComparator.loadJson(json1), JSonDirectComparator.loadJson(json2), MonkeyPathRepresentation.REPRESENTATION, jsonParams, inclusionsTemplate, exclusionsTemplate);
    }

    private static class Values {
        private final Path keyPath;
        private final PathCluster cluster1;
        private final PathCluster cluster2;
        private final Object value1;
        private final JSONParam param1;
        private final Object value2;
        private final JSONParam param2;

        public Values(Path keyPath, PathCluster cluster1, PathCluster cluster2, Object value1, JSONParam param1, Object value2, JSONParam param2) {
            this.keyPath = Objects.requireNonNull(keyPath);
            this.cluster1 = Objects.requireNonNull(cluster1);
            this.cluster2 = Objects.requireNonNull(cluster2);
            this.value1 = value1;
            this.param1 = param1;
            this.value2 = value2;
            this.param2 = param2;
        }

        public Path keyPath() {
            return this.keyPath;
        }

        public PathCluster cluster1() {
            return this.cluster1;
        }

        public PathCluster cluster2() {
            return this.cluster1;
        }

        public Object value1() {
            return this.value1;
        }

        public JSONParam param1() {
            return this.param1;
        }

        public Object value2() {
            return this.value2;
        }

        public JSONParam param2() {
            return this.param2;
        }

        public boolean valuesDefined() {
            return this.value1() != null && this.value2() != null;
        }

        public boolean oneValueNotDefined() {
            return this.value1() == null != (this.value2() == null);
        }

        public boolean valuesHaveSameType() {
            return this.value1() == null && this.value2() == null || this.value1() != null && this.value2() != null && this.value1().getClass() == this.value2().getClass();
        }

        private Values applyParams(JSONParams params) {
            Objects.requireNonNull(params);
            if (!(this.value1() instanceof String) && !(this.value2() instanceof String)) {
                return this;
            }
            return new Values(this.keyPath, this.cluster1, this.cluster2, Values.value(this.value1()), Values.appliedParam(this.value1(), params), Values.value(this.value2()), Values.appliedParam(this.value2(), params));
        }

        private static Object value(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof String)) {
                return value;
            }
            String stringVal = (String)value;
            if (!JSonDirectComparator.hasParam(stringVal)) {
                return value;
            }
            return null;
        }

        public static JSONParam appliedParam(Object value, JSONParams params) {
            Objects.requireNonNull(params);
            if (value == null) {
                return null;
            }
            if (!(value instanceof String)) {
                return null;
            }
            String stringVal = (String)value;
            if (!JSonDirectComparator.hasParam(stringVal)) {
                return null;
            }
            String paramName = JSonDirectComparator.extractParamName(stringVal);
            JSONParam jsonParam = params.get(paramName);
            CommonUtils.check(() -> jsonParam != null, () -> new ParamNotFound(String.format(JSonDirectComparator.PARAM_NOT_FOUND, jsonParam.name())));
            return jsonParam;
        }
    }
}

