/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2.Comparators;
import com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2.CompareTo;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CompatibleTypesComparatorV2 {
    private static final int VERSION = 2;
    private static final Map<TypesKey, CompareTo> COMPATIBLE_TYPES = (Map)CommonUtils.eval(() -> Stream.of(new Comparators.SameTypeComparator<String>(String.class), new Comparators.SameTypeComparator<Byte>(Byte.class), new Comparators.SameTypeComparator<Byte>(Byte.TYPE), new Comparators.IntegerTypesComparator<Byte, Byte>(Byte.TYPE, Byte.class), new Comparators.IntegerTypesComparator<Byte, Short>(Byte.TYPE, Short.class), new Comparators.IntegerTypesComparator<Byte, Short>(Byte.class, Short.class), new Comparators.IntegerTypesComparator<Byte, Integer>(Byte.TYPE, Integer.class), new Comparators.IntegerTypesComparator<Byte, Integer>(Byte.class, Integer.class), new Comparators.IntegerTypesComparator<Byte, Long>(Byte.TYPE, Long.class), new Comparators.IntegerTypesComparator<Byte, Long>(Byte.class, Long.class), new Comparators.IntFloatTypesComparator<Byte, Float>(Byte.TYPE, Float.class), new Comparators.IntFloatTypesComparator<Byte, Float>(Byte.class, Float.class), new Comparators.IntFloatTypesComparator<Byte, Double>(Byte.TYPE, Double.class), new Comparators.IntFloatTypesComparator<Byte, Double>(Byte.class, Double.class), new Comparators.IntegerTypesComparator<Byte, Byte>(Byte.class, Byte.TYPE), new Comparators.IntegerTypesComparator<Byte, Short>(Byte.TYPE, Short.TYPE), new Comparators.IntegerTypesComparator<Byte, Short>(Byte.class, Short.TYPE), new Comparators.IntegerTypesComparator<Byte, Integer>(Byte.TYPE, Integer.TYPE), new Comparators.IntegerTypesComparator<Byte, Integer>(Byte.class, Integer.TYPE), new Comparators.IntegerTypesComparator<Byte, Long>(Byte.TYPE, Long.TYPE), new Comparators.IntegerTypesComparator<Byte, Long>(Byte.class, Long.TYPE), new Comparators.IntFloatTypesComparator<Byte, Float>(Byte.TYPE, Float.TYPE), new Comparators.IntFloatTypesComparator<Byte, Float>(Byte.class, Float.TYPE), new Comparators.IntFloatTypesComparator<Byte, Double>(Byte.TYPE, Double.TYPE), new Comparators.IntFloatTypesComparator<Byte, Double>(Byte.class, Double.TYPE), new Comparators.SameTypeComparator<Short>(Short.class), new Comparators.SameTypeComparator<Short>(Short.TYPE), new Comparators.IntegerTypesComparator<Short, Byte>(Short.TYPE, Byte.class), new Comparators.IntegerTypesComparator<Short, Byte>(Short.class, Byte.class), new Comparators.IntegerTypesComparator<Short, Short>(Short.TYPE, Short.class), new Comparators.IntegerTypesComparator<Short, Integer>(Short.TYPE, Integer.class), new Comparators.IntegerTypesComparator<Short, Integer>(Short.class, Integer.class), new Comparators.IntegerTypesComparator<Short, Long>(Short.TYPE, Long.class), new Comparators.IntegerTypesComparator<Short, Long>(Short.class, Long.class), new Comparators.IntFloatTypesComparator<Short, Float>(Short.TYPE, Float.class), new Comparators.IntFloatTypesComparator<Short, Float>(Short.class, Float.class), new Comparators.IntFloatTypesComparator<Short, Double>(Short.TYPE, Double.class), new Comparators.IntFloatTypesComparator<Short, Double>(Short.class, Double.class), new Comparators.IntegerTypesComparator<Short, Byte>(Short.TYPE, Byte.TYPE), new Comparators.IntegerTypesComparator<Short, Byte>(Short.class, Byte.TYPE), new Comparators.IntegerTypesComparator<Short, Short>(Short.class, Short.TYPE), new Comparators.IntegerTypesComparator<Short, Integer>(Short.TYPE, Integer.TYPE), new Comparators.IntegerTypesComparator<Short, Integer>(Short.class, Integer.TYPE), new Comparators.IntegerTypesComparator<Short, Long>(Short.TYPE, Long.TYPE), new Comparators.IntegerTypesComparator<Short, Long>(Short.class, Long.TYPE), new Comparators.IntFloatTypesComparator<Short, Float>(Short.TYPE, Float.TYPE), new Comparators.IntFloatTypesComparator<Short, Float>(Short.class, Float.TYPE), new Comparators.IntFloatTypesComparator<Short, Double>(Short.TYPE, Double.TYPE), new Comparators.IntFloatTypesComparator<Short, Double>(Short.class, Double.TYPE), new Comparators.SameTypeComparator<Integer>(Integer.class), new Comparators.SameTypeComparator<Integer>(Integer.TYPE), new Comparators.IntegerTypesComparator<Integer, Byte>(Integer.TYPE, Byte.class), new Comparators.IntegerTypesComparator<Integer, Byte>(Integer.class, Byte.class), new Comparators.IntegerTypesComparator<Integer, Short>(Integer.TYPE, Short.class), new Comparators.IntegerTypesComparator<Integer, Short>(Integer.class, Short.class), new Comparators.IntegerTypesComparator<Integer, Integer>(Integer.TYPE, Integer.class), new Comparators.IntegerTypesComparator<Integer, Long>(Integer.TYPE, Long.class), new Comparators.IntegerTypesComparator<Integer, Long>(Integer.class, Long.class), new Comparators.IntFloatTypesComparator<Integer, Float>(Integer.TYPE, Float.class), new Comparators.IntFloatTypesComparator<Integer, Float>(Integer.class, Float.class), new Comparators.IntFloatTypesComparator<Integer, Double>(Integer.TYPE, Double.class), new Comparators.IntFloatTypesComparator<Integer, Double>(Integer.class, Double.class), new Comparators.IntegerTypesComparator<Integer, Byte>(Integer.TYPE, Byte.TYPE), new Comparators.IntegerTypesComparator<Integer, Byte>(Integer.class, Byte.TYPE), new Comparators.IntegerTypesComparator<Integer, Short>(Integer.TYPE, Short.TYPE), new Comparators.IntegerTypesComparator<Integer, Short>(Integer.class, Short.TYPE), new Comparators.IntegerTypesComparator<Integer, Integer>(Integer.class, Integer.TYPE), new Comparators.IntegerTypesComparator<Integer, Long>(Integer.TYPE, Long.TYPE), new Comparators.IntegerTypesComparator<Integer, Long>(Integer.class, Long.TYPE), new Comparators.IntFloatTypesComparator<Integer, Float>(Integer.TYPE, Float.TYPE), new Comparators.IntFloatTypesComparator<Integer, Float>(Integer.class, Float.TYPE), new Comparators.IntFloatTypesComparator<Integer, Double>(Integer.TYPE, Double.TYPE), new Comparators.IntFloatTypesComparator<Integer, Double>(Integer.class, Double.TYPE), new Comparators.SameTypeComparator<Long>(Long.class), new Comparators.SameTypeComparator<Long>(Long.TYPE), new Comparators.IntegerTypesComparator<Long, Byte>(Long.TYPE, Byte.class), new Comparators.IntegerTypesComparator<Long, Byte>(Long.class, Byte.class), new Comparators.IntegerTypesComparator<Long, Short>(Long.TYPE, Short.class), new Comparators.IntegerTypesComparator<Long, Short>(Long.class, Short.class), new Comparators.IntegerTypesComparator<Long, Integer>(Long.TYPE, Integer.class), new Comparators.IntegerTypesComparator<Long, Integer>(Long.class, Integer.class), new Comparators.IntegerTypesComparator<Long, Long>(Long.TYPE, Long.class), new Comparators.IntFloatTypesComparator<Long, Float>(Long.TYPE, Float.class), new Comparators.IntFloatTypesComparator<Long, Float>(Long.class, Float.class), new Comparators.IntFloatTypesComparator<Long, Double>(Long.TYPE, Double.class), new Comparators.IntFloatTypesComparator<Long, Double>(Long.class, Double.class), new Comparators.IntegerTypesComparator<Long, Byte>(Long.TYPE, Byte.TYPE), new Comparators.IntegerTypesComparator<Long, Byte>(Long.class, Byte.TYPE), new Comparators.IntegerTypesComparator<Long, Short>(Long.TYPE, Short.TYPE), new Comparators.IntegerTypesComparator<Long, Short>(Long.class, Short.TYPE), new Comparators.IntegerTypesComparator<Long, Integer>(Long.TYPE, Integer.TYPE), new Comparators.IntegerTypesComparator<Long, Integer>(Long.class, Integer.TYPE), new Comparators.IntegerTypesComparator<Long, Long>(Long.class, Long.TYPE), new Comparators.IntFloatTypesComparator<Long, Float>(Long.TYPE, Float.TYPE), new Comparators.IntFloatTypesComparator<Long, Float>(Long.class, Float.TYPE), new Comparators.IntFloatTypesComparator<Long, Double>(Long.TYPE, Double.TYPE), new Comparators.IntFloatTypesComparator<Long, Double>(Long.class, Double.TYPE), new Comparators.SameTypeComparator<Float>(Float.class), new Comparators.SameTypeComparator<Float>(Float.TYPE), new Comparators.IntFloatTypesComparator<Float, Byte>(Float.class, Byte.class), new Comparators.IntFloatTypesComparator<Float, Byte>(Float.TYPE, Byte.class), new Comparators.IntFloatTypesComparator<Float, Short>(Float.class, Short.class), new Comparators.IntFloatTypesComparator<Float, Short>(Float.TYPE, Short.class), new Comparators.IntFloatTypesComparator<Float, Integer>(Float.class, Integer.class), new Comparators.IntFloatTypesComparator<Float, Integer>(Float.TYPE, Integer.class), new Comparators.IntFloatTypesComparator<Float, Long>(Float.class, Long.class), new Comparators.IntFloatTypesComparator<Float, Long>(Float.TYPE, Long.class), new Comparators.FloatTypesComparator<Float, Float>(Float.class, Float.TYPE), new Comparators.FloatTypesComparator<Float, Float>(Float.TYPE, Float.class), new Comparators.FloatTypesComparator<Float, Double>(Float.TYPE, Double.class), new Comparators.FloatTypesComparator<Float, Double>(Float.class, Double.TYPE), new Comparators.FloatTypesComparator<Float, Double>(Float.TYPE, Double.TYPE), new Comparators.FloatTypesComparator<Float, Double>(Float.class, Double.class), new Comparators.SameTypeComparator<Double>(Double.class), new Comparators.SameTypeComparator<Double>(Double.TYPE), new Comparators.IntFloatTypesComparator<Double, Byte>(Double.class, Byte.class), new Comparators.IntFloatTypesComparator<Double, Byte>(Double.TYPE, Byte.class), new Comparators.IntFloatTypesComparator<Double, Short>(Double.class, Short.class), new Comparators.IntFloatTypesComparator<Double, Short>(Double.TYPE, Short.class), new Comparators.IntFloatTypesComparator<Double, Integer>(Double.class, Integer.class), new Comparators.IntFloatTypesComparator<Double, Integer>(Double.TYPE, Integer.class), new Comparators.IntFloatTypesComparator<Double, Long>(Double.class, Long.class), new Comparators.IntFloatTypesComparator<Double, Long>(Double.TYPE, Long.class), new Comparators.FloatTypesComparator<Double, Double>(Double.class, Double.TYPE), new Comparators.FloatTypesComparator<Double, Double>(Double.TYPE, Double.class), new Comparators.FloatTypesComparator<Double, Float>(Double.class, Float.class), new Comparators.FloatTypesComparator<Double, Float>(Double.class, Float.TYPE), new Comparators.FloatTypesComparator<Double, Float>(Double.TYPE, Float.class), new Comparators.FloatTypesComparator<Double, Float>(Double.TYPE, Float.TYPE), new Comparators.SameTypeComparator<Character>(Character.class), new Comparators.SameTypeComparator<Character>(Character.TYPE), new Comparators.CharacterTypesComparator<Character, Character>(Character.TYPE, Character.class), new Comparators.CharacterTypesComparator<Character, Character>(Character.class, Character.TYPE), new Comparators.SameTypeComparator<Boolean>(Boolean.class), new Comparators.SameTypeComparator<Boolean>(Boolean.TYPE), new Comparators.BooleanTypesComparator<Boolean, Boolean>(Boolean.TYPE, Boolean.class), new Comparators.BooleanTypesComparator<Boolean, Boolean>(Boolean.class, Boolean.TYPE)).collect(Collectors.toMap(c -> new TypesKey(c.type1(), c.type2()), c -> c)));

    public static int version() {
        return 2;
    }

    public static boolean objectTypesCompatible(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && COMPATIBLE_TYPES.containsKey(new TypesKey(o1.getClass(), o2.getClass()));
    }

    public static boolean compatibleEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null != (o2 == null)) {
            return false;
        }
        return COMPATIBLE_TYPES.getOrDefault(new TypesKey(o1.getClass(), o2.getClass()), Comparators.NEVER_COMPARED).isEqualTo(o1, o2);
    }

    private static final class TypesKey {
        private final Class type1;
        private final Class type2;

        private TypesKey(Class type1, Class type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypesKey)) {
                return false;
            }
            TypesKey typesKey = (TypesKey)o;
            if (this.type1 != null ? !this.type1.equals(typesKey.type1) : typesKey.type1 != null) {
                return false;
            }
            return this.type2 != null ? this.type2.equals(typesKey.type2) : typesKey.type2 == null;
        }

        public int hashCode() {
            int result = this.type1 != null ? this.type1.hashCode() : 0;
            result = 31 * result + (this.type2 != null ? this.type2.hashCode() : 0);
            return result;
        }
    }
}

