/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.defaults.DefaultWidgetNode;
import com.steammachine.jsonchecker.impl.ver1.DefaultExtraInfo;
import com.steammachine.jsonchecker.impl.ver1.DefaultInterfaceInfo;
import com.steammachine.jsonchecker.impl.ver1.DefaultTreeNode;
import com.steammachine.jsonchecker.impl.ver1.InterfaceInfo;
import com.steammachine.jsonchecker.impl.ver1.ObjectInformation;
import com.steammachine.jsonchecker.impl.ver1.ParamInfo;
import com.steammachine.jsonchecker.impl.ver1.ReservedWords;
import com.steammachine.jsonchecker.types.ExtraInfo;
import com.steammachine.jsonchecker.types.LoadResult;
import com.steammachine.jsonchecker.types.TreeNode;
import com.steammachine.jsonchecker.types.exceptions.MalformedDocument;
import com.steammachine.jsonchecker.types.exceptions.ParamNotFound;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JSonMapper {
    private static final Predicate<Map.Entry<String, List<String>>> MORE_THAN_ONE_ITEM = e -> ((List)e.getValue()).size() > 1;
    private static final Predicate<Map.Entry<String, List<ParamInfo>>> MORE_THAN_ONE_PARAM = e -> ((List)e.getValue()).size() > 1;

    public static LoadResult load(String path, Class defaultClass, Map<String, Object> params) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream((InputStream)CommonUtils.suppress(() -> new FileInputStream(path)));){
            LoadResult loadResult = JSonMapper.load(stream, defaultClass, params);
            return loadResult;
        }
    }

    public static LoadResult load(String path, Map<String, Object> param) throws IOException {
        return JSonMapper.load(path, DefaultWidgetNode.class, param);
    }

    public static LoadResult load(String path) throws IOException {
        return JSonMapper.load(path, DefaultWidgetNode.class, Collections.emptyMap());
    }

    public static LoadResult load(InputStream stream, Class defaultClass, Map<String, Object> params) {
        Object root = CommonUtils.suppress(() -> new JSONParser().parse((Reader)new InputStreamReader(stream)));
        InterfaceInfo interfaceInfo = JSonMapper.loadInterfaceInfo(defaultClass, params, root);
        List<ObjectInformation> objects = JSonMapper.loadTreeAsList(root, interfaceInfo);
        final TreeNode rootNode = JSonMapper.fixup(objects);
        final DefaultExtraInfo extraInfo = new DefaultExtraInfo(interfaceInfo.userDefinedData());
        return new LoadResult(){

            @Override
            public TreeNode root() {
                return rootNode;
            }

            @Override
            public ExtraInfo extrainfo() {
                return extraInfo;
            }
        };
    }

    private static InterfaceInfo loadInterfaceInfo(Class defaultClass, Map<String, Object> params, Object jsonRoot) {
        Objects.requireNonNull(defaultClass);
        DefaultInterfaceInfo info = new DefaultInterfaceInfo();
        info.setDefaultNodeClass(defaultClass);
        if (!(jsonRoot instanceof JSONObject)) {
            return info.lock();
        }
        if (!(((JSONObject)jsonRoot).get((Object)ReservedWords.INTERFACE.ident()) instanceof JSONObject)) {
            return info.lock();
        }
        JSONObject interfaceNode = (JSONObject)((JSONObject)jsonRoot).get((Object)ReservedWords.INTERFACE.ident());
        JSonMapper.check(interfaceNode.get((Object)ReservedWords.TYPES.ident()) == null || interfaceNode.get((Object)ReservedWords.TYPES.ident()) instanceof JSONObject, () -> ReservedWords.TYPES.ident() + " element must be of type " + JSONObject.class);
        if (interfaceNode.get((Object)ReservedWords.TYPES.ident()) != null) {
            JSONObject types = (JSONObject)interfaceNode.get((Object)ReservedWords.TYPES.ident());
            if (types.get((Object)ReservedWords.ITEMS.ident()) != null) {
                JSonMapper.check(types.get((Object)ReservedWords.ITEMS.ident()) instanceof JSONArray, () -> "items element must be of type " + JSONObject.class);
                info.types().putAll(JSonMapper.loadTypes(types.get((Object)ReservedWords.ITEMS.ident())));
            }
            if (types.get((Object)ReservedWords.DEFAULTCLASS.ident()) != null) {
                JSonMapper.check(types.get((Object)ReservedWords.DEFAULTCLASSALIAS.ident()) == null, () -> ReservedWords.DEFAULTCLASS.ident() + " and " + ReservedWords.DEFAULTCLASSALIAS.ident() + " cannnot be defined simulteniousely");
            }
            if (types.get((Object)ReservedWords.DEFAULTCLASSALIAS.ident()) != null) {
                JSonMapper.check(types.get((Object)ReservedWords.DEFAULTCLASS.ident()) == null, () -> ReservedWords.DEFAULTCLASS.ident() + " and " + ReservedWords.DEFAULTCLASSALIAS.ident() + " cannnot be defined simulteniousely");
            }
            if (types.get((Object)ReservedWords.DEFAULTCLASSALIAS.ident()) != null) {
                JSonMapper.check(types.get((Object)ReservedWords.DEFAULTCLASSALIAS.ident()) instanceof String, () -> ReservedWords.DEFAULTCLASSALIAS.ident() + " element must be of type " + JSONObject.class);
                String classAliasName = (String)types.get((Object)ReservedWords.DEFAULTCLASSALIAS.ident());
                JSonMapper.check(info.types().get(classAliasName) != null, () -> "no class found for alias " + classAliasName);
                info.setDefaultNodeClass(info.types().get(classAliasName));
            } else if (types.get((Object)ReservedWords.DEFAULTCLASS.ident()) != null) {
                JSonMapper.check(types.get((Object)ReservedWords.DEFAULTCLASS.ident()) instanceof String, () -> ReservedWords.DEFAULTCLASS.ident() + " element must be of type " + JSONObject.class);
                String className = (String)types.get((Object)ReservedWords.DEFAULTCLASS.ident());
                info.setDefaultNodeClass((Class)CommonUtils.suppress(() -> Class.forName(className)));
            }
        }
        if (interfaceNode.get((Object)ReservedWords.PARAMS.ident()) != null) {
            JSonMapper.check(interfaceNode.get((Object)ReservedWords.PARAMS.ident()) instanceof JSONArray, () -> ReservedWords.PARAMS.ident() + " element must be of type " + JSONArray.class);
            info.params().putAll(JSonMapper.loadParams(params, interfaceNode.get((Object)ReservedWords.PARAMS.ident())));
        }
        if (interfaceNode.get((Object)ReservedWords.USERDATA.ident()) != null) {
            JSonMapper.check(interfaceNode.get((Object)ReservedWords.USERDATA.ident()) instanceof JSONArray, () -> ReservedWords.USERDATA.ident() + " element must be of type " + JSONArray.class);
            info.userDefinedData().addAll(JSonMapper.loadUserData(interfaceNode.get((Object)ReservedWords.USERDATA.ident())));
        }
        return info.lock();
    }

    private static DefautParamInfo parseParamInfo(JSONObject jsonObject) {
        Objects.requireNonNull(jsonObject);
        DefautParamInfo result = new DefautParamInfo();
        JSonMapper.check(jsonObject.get((Object)ReservedWords.NAME.ident()) != null, () -> "name item must be present in each param");
        JSonMapper.check(jsonObject.get((Object)ReservedWords.NAME.ident()) instanceof String, () -> "name item must be of type String in each param");
        result.setName((String)jsonObject.get((Object)ReservedWords.NAME.ident()));
        JSonMapper.check(jsonObject.get((Object)ReservedWords.CLASS.ident()) != null, () -> "class item must be present in each param");
        JSonMapper.check(jsonObject.get((Object)ReservedWords.CLASS.ident()) instanceof String, () -> "class item must be of type String in each param");
        result.setClass(ObjectInformation.getLoadedClass((String)jsonObject.get((Object)ReservedWords.CLASS.ident())));
        if (jsonObject.get((Object)ReservedWords.DEFAULT.ident()) != null) {
            String defaultValue = "" + jsonObject.get((Object)ReservedWords.DEFAULT.ident());
            JSonMapper.check(ObjectInformation.isValue(result.clazz()), () -> "param type must be one of " + ObjectInformation.VALUE_CLASSES.values());
            result.setDefaultValue(ObjectInformation.value(result.clazz(), defaultValue));
        }
        return result;
    }

    private static List<String> loadUserData(Object json) {
        JSonMapper.check(json instanceof JSONArray, () -> "json object must be JSONArray");
        return Stream.of(((JSONArray)json).toArray()).filter(i -> i instanceof String).map(o -> (String)o).collect(Collectors.toList());
    }

    private static Map<String, Object> loadParams(Map<String, Object> params, Object json) {
        JSonMapper.check(json instanceof JSONArray, () -> "json object must be JSONArray");
        Map<String, Object> parametrs = params != null ? params : Collections.emptyMap();
        List definedParams = Stream.of(((JSONArray)json).toArray()).filter(o -> o instanceof JSONObject).map(o -> (JSONObject)o).map(JSonMapper::parseParamInfo).map(i -> i.setValues(parametrs)).collect(Collectors.toList());
        Map<String, List> preQweriedParams = definedParams.stream().collect(Collectors.toMap(ParamInfo::name, Collections::singletonList, JSonMapper::reduceList));
        if (preQweriedParams.entrySet().stream().anyMatch(MORE_THAN_ONE_PARAM)) {
            String message = preQweriedParams.entrySet().stream().filter(MORE_THAN_ONE_PARAM).map(e -> "param " + (String)e.getKey() + " is mapped to " + e.getValue()).reduce("Some params are declared more than one time:", (s, s2) -> s + "\r\n" + s2);
            throw new MalformedDocument(message);
        }
        return definedParams.stream().collect(Collectors.toMap(ParamInfo::name, ParamInfo::value));
    }

    private static Map<String, Class> loadTypes(Object jsonRoot) {
        Objects.requireNonNull(jsonRoot);
        JSonMapper.check(jsonRoot instanceof JSONArray, () -> "jsonRoot(" + jsonRoot + ") is not instanceof JSONArray");
        List classAndAlias = Stream.of(((JSONArray)jsonRoot).toArray()).filter(o -> o instanceof JSONObject).map(o -> (JSONObject)o).map(ti -> (String[])CommonUtils.toArray((Object[])new String[]{(String)ti.get((Object)ReservedWords.CLASS_ALIAS.ident()), (String)ti.get((Object)ReservedWords.CLASS.ident())})).collect(Collectors.toList());
        Map<String, List> collect = classAndAlias.stream().collect(Collectors.toMap(a -> a[0], a -> Collections.singletonList(a[1]), JSonMapper::reduceList));
        if (collect.entrySet().stream().anyMatch(MORE_THAN_ONE_ITEM)) {
            String message = collect.entrySet().stream().filter(MORE_THAN_ONE_ITEM).map(e -> "type alias " + (String)e.getKey() + " is mapped to " + e.getValue() + " classes").reduce("Some type aliases are mapped more than once:", (s, s2) -> s + "\r\n" + s2);
            throw new MalformedDocument(message);
        }
        return classAndAlias.stream().collect(Collectors.toMap(a -> a[0], a -> (Class)CommonUtils.suppress(() -> Class.forName(a[1]))));
    }

    private static <T> List<T> reduceList(List<T> l1, List<T> l2) {
        ArrayList<T> accumumator = new ArrayList<T>();
        accumumator.addAll(l1);
        accumumator.addAll(l2);
        return accumumator;
    }

    private static List<ObjectInformation> loadTreeAsList(Object jsonRoot, InterfaceInfo interfaceInfo) {
        ArrayList<ObjectInformation> objInfos = new ArrayList<ObjectInformation>();
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        JSonMapper.loadFlat(jsonRoot, null, interfaceInfo, objInfos, namespace);
        return objInfos;
    }

    private static void loadFlat(Object jsobj, Object parent, InterfaceInfo interfaceInfo, List<ObjectInformation> objInfos, Map<String, Object> namespace) {
        Objects.requireNonNull(interfaceInfo);
        if (jsobj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)jsobj;
            if (jsonObject.get((Object)ReservedWords.CLASS.ident()) != null) {
                JSonMapper.check(jsonObject.get((Object)ReservedWords.CLASS_ALIAS.ident()) == null, () -> "class and classalias items must not be defined at the same time");
            }
            if (jsonObject.get((Object)ReservedWords.CLASS_ALIAS.ident()) != null) {
                JSonMapper.check(jsonObject.get((Object)ReservedWords.CLASS.ident()) == null, () -> "class and classalias items must not be defined at the same time");
            }
            Class clazz = JSonMapper.getInstanceClass(interfaceInfo, jsonObject);
            Object instance = CommonUtils.suppress(clazz::newInstance);
            if (jsonObject.get((Object)ReservedWords.INSTANCE_NAME.ident()) != null) {
                JSonMapper.check(jsonObject.get((Object)ReservedWords.INSTANCE_NAME.ident()) instanceof String, null);
            }
            String instancename = jsonObject.get((Object)ReservedWords.INSTANCE_NAME.ident()) != null ? (String)jsonObject.get((Object)ReservedWords.INSTANCE_NAME.ident()) : null;
            ObjectInformation info = new ObjectInformation(parent, instance, instancename, namespace);
            objInfos.add(info);
            jsonObject.entrySet().stream().filter(e -> !JSonMapper.excludedPropertyName(parent == null, (String)e.getKey())).forEach(e -> JSonMapper.setValue(interfaceInfo, info, e));
            Object children = jsonObject.get((Object)ReservedWords.CHILDREN.ident());
            if (children != null) {
                JSonMapper.check(children instanceof JSONArray, () -> "children element must be of type JSONArray");
                JSONArray childrenArray = (JSONArray)children;
                for (Object arrayItem : childrenArray) {
                    JSonMapper.loadFlat(arrayItem, instance, interfaceInfo, objInfos, namespace);
                }
            }
        }
    }

    private static Class getInstanceClass(InterfaceInfo interfaceInfo, JSONObject jsonObject) {
        Class clazz;
        if (jsonObject.get((Object)ReservedWords.CLASS.ident()) != null) {
            JSonMapper.check(jsonObject.get((Object)ReservedWords.CLASS.ident()) instanceof String, () -> "class item must be of type String");
            clazz = ObjectInformation.getLoadedClass((String)jsonObject.get((Object)ReservedWords.CLASS.ident()));
        } else if (jsonObject.get((Object)ReservedWords.CLASS_ALIAS.ident()) != null) {
            JSonMapper.check(jsonObject.get((Object)ReservedWords.CLASS_ALIAS.ident()) instanceof String, () -> "class alias item must be of type String");
            String type = (String)jsonObject.get((Object)ReservedWords.CLASS_ALIAS.ident());
            JSonMapper.check(interfaceInfo.types().get(type) != null, () -> "class alias " + type + " not found");
            clazz = interfaceInfo.types().get(type);
        } else {
            clazz = interfaceInfo.defaultClass();
        }
        return clazz;
    }

    private static void setValue(InterfaceInfo interfaceInfo, ObjectInformation info, Map.Entry<String, Object> entry) {
        Objects.requireNonNull(interfaceInfo);
        Objects.requireNonNull(info);
        Objects.requireNonNull(entry);
        if (entry.getValue() == null) {
            info.setValueCandidate(entry.getKey(), null);
        } else if (JSonMapper.isParamRef("" + entry.getValue())) {
            String paramName = JSonMapper.refParamName("" + entry.getValue());
            JSonMapper.check(() -> interfaceInfo.params().containsKey(paramName), () -> new ParamNotFound("param " + paramName + " not found"));
            info.setValue(entry.getKey(), interfaceInfo.params().get(paramName));
        } else {
            info.setValueCandidate(entry.getKey(), "" + entry.getValue());
        }
    }

    private static boolean isParamRef(String valueCandidate) {
        return valueCandidate != null && valueCandidate.startsWith("${") && valueCandidate.endsWith("}");
    }

    private static String refParamName(String valueCandidate) {
        if (!JSonMapper.isParamRef(valueCandidate)) {
            throw new IllegalArgumentException("valueCandidate " + valueCandidate + " is not parametr reference");
        }
        return valueCandidate.substring("${".length(), valueCandidate.length() - "}".length());
    }

    private static boolean excludedPropertyName(boolean root, String propertyName) {
        if (root) {
            return ReservedWords.INTERFACE.ident().equals(propertyName) || ReservedWords.everyObjectExclusion(propertyName);
        }
        return ReservedWords.everyObjectExclusion(propertyName);
    }

    private static TreeNode fixup(List<ObjectInformation> infos) {
        Objects.requireNonNull(infos);
        List fixes = ((Stream)infos.stream().sequential()).map(i -> new DefaultTreeNodeHolder(new DefaultTreeNode(i.object()), (ObjectInformation)i)).collect(Collectors.toList());
        for (DefaultTreeNodeHolder parent : fixes) {
            for (DefaultTreeNodeHolder child : fixes) {
                if (parent == child || parent.info().object() != child.info().parentobject()) continue;
                parent.node().addChild(child.node());
            }
        }
        infos.forEach(ObjectInformation::fixup);
        return ((DefaultTreeNodeHolder)fixes.get(0)).node();
    }

    private static void check(boolean condition, Supplier<String> stringSupplier) {
        if (!condition) {
            String additionalMessage = stringSupplier == null ? "" : "\r\n with message " + stringSupplier.get();
            throw new IllegalStateException("condition failed" + additionalMessage);
        }
    }

    private static void check(BooleanSupplier condition, Supplier<? extends RuntimeException> errorSupplier) {
        Objects.requireNonNull(condition);
        Objects.requireNonNull(errorSupplier);
        if (!condition.getAsBoolean()) {
            throw errorSupplier.get();
        }
    }

    private static class DefaultTreeNodeHolder {
        private final DefaultTreeNode node;
        private final ObjectInformation info;

        private DefaultTreeNodeHolder(DefaultTreeNode node, ObjectInformation info) {
            this.node = Objects.requireNonNull(node);
            this.info = Objects.requireNonNull(info);
        }

        public DefaultTreeNode node() {
            return this.node;
        }

        public ObjectInformation info() {
            return this.info;
        }
    }

    static class DefautParamInfo
    implements ParamInfo {
        Class clazz;
        String name;
        Object defaultValue;
        Object value;
        boolean hasDefault;

        DefautParamInfo() {
        }

        @Override
        public Class clazz() {
            return this.clazz;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Object value() {
            return this.value;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public boolean hasDefault() {
            return this.hasDefault;
        }

        public void setClass(Class clazz) {
            this.clazz = clazz;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.hasDefault = true;
        }

        public DefautParamInfo setValues(Map<String, Object> params) {
            Objects.requireNonNull(params);
            if (!this.hasDefault() && !params.containsKey(this.name())) {
                throw new IllegalStateException("param " + this.name() + " is not found");
            }
            this.value = this.defaultValue;
            if (params.containsKey(this.name())) {
                this.value = params.get(this.name());
            }
            return this;
        }

        public String toString() {
            return "DefautParamInfo{clazz=" + this.clazz + ", name='" + this.name + '\'' + ", defaultValue=" + this.defaultValue + ", VALUE=" + this.value + ", hasDefault=" + this.hasDefault + '}';
        }
    }
}

