/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils;

import com.steammachine.jsonchecker.defaults.DefaultWidgetNodeChecker;
import com.steammachine.jsonchecker.impl.internal.Association;
import com.steammachine.jsonchecker.impl.internal.DefaultAssociation;
import com.steammachine.jsonchecker.types.Identity;
import com.steammachine.jsonchecker.types.SqNodeKeyType;
import com.steammachine.jsonchecker.types.TreeNode;
import com.steammachine.jsonchecker.types.exceptions.PathError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Deprecated
public class JSonExclusions {
    private static final String SLASH = "/";
    private static final Pattern ITEM_PATTERN = Pattern.compile("^([*]|([@]?[a-zA-Z0-9_]+))$");
    private static final Predicate<String> ITEM_PATTERN_PREDICATE = ITEM_PATTERN.asPredicate();
    private static final Predicate<String> ITEM_PATTERN_FILTER = ITEM_PATTERN_PREDICATE.negate();
    private static final Pattern LAST_ITEM_PATTERN = Pattern.compile("^([*]{1,2}|([@]?[a-zA-Z0-9_]+))$");
    private static final Predicate<String> LAST_ITEM_PREDICATE = LAST_ITEM_PATTERN.asPredicate();
    private static final Predicate<String> LAST_ITEM_FILTER = LAST_ITEM_PREDICATE.negate();

    public static Association<Boolean> collectProcessed(TreeNode root, Collection<String> exclusions) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(exclusions);
        ArrayList<List<TreeNode>> list = new ArrayList<List<TreeNode>>();
        list.add(Collections.singletonList(root));
        for (int index = 0; index < list.size(); ++index) {
            List node = (List)list.get(index);
            Iterator<TreeNode> children = ((TreeNode)node.get(node.size() - 1)).children();
            while (children.hasNext()) {
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
                treeNodes.addAll(node);
                treeNodes.add(children.next());
                list.add(treeNodes);
            }
        }
        return list.stream().map(l -> new ProcessedResult(JSonExclusions.isNodeProcessed(l, exclusions), (TreeNode)JSonExclusions.last(l))).collect(DefaultAssociation::new, (c, r) -> c.associate(r.treeNode().object(), r.processed()), DefaultAssociation::mergeWith);
    }

    private static void debug(boolean result, List<TreeNode> node, Collection<String> exclusions) {
        String debugName = JSonExclusions.debugName(node);
        JSonExclusions.isNodeProcessed(node, exclusions);
    }

    private static String debugName(List<TreeNode> node) {
        return node.stream().map(tr -> (DefaultWidgetNodeChecker)tr.object()).map(i -> SLASH + i.monkeyId()).collect(Collectors.joining());
    }

    private static void debugInspection(Collection<String> exclusions, List<TreeNode> l) {
        ProcessedResult result = new ProcessedResult(JSonExclusions.isNodeProcessed(l, exclusions), JSonExclusions.last(l));
    }

    public static Association<String> collectNodeNames(TreeNode root) {
        ArrayList<List<TreeNode>> list = new ArrayList<List<TreeNode>>();
        list.add(Collections.singletonList(root));
        for (int index = 0; index < list.size(); ++index) {
            List node = (List)list.get(index);
            Iterator<TreeNode> children = ((TreeNode)node.get(node.size() - 1)).children();
            while (children.hasNext()) {
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
                treeNodes.addAll(node);
                treeNodes.add(children.next());
                list.add(treeNodes);
            }
        }
        return list.stream().map(l -> new CollectsFullNodeNameResult((List<TreeNode>)l, (TreeNode)JSonExclusions.last(l))).collect(DefaultAssociation::new, (a, r) -> a.associate(r.treeNode().object(), r.fullPath()), DefaultAssociation::mergeWith);
    }

    private static <T> T last(List<T> list) {
        Objects.requireNonNull(list);
        return list.get(list.size() - 1);
    }

    private static boolean isNodeProcessed(List<TreeNode> fullNode, Collection<String> exclusions) {
        Objects.requireNonNull(fullNode);
        Objects.requireNonNull(exclusions);
        if (fullNode.isEmpty()) {
            throw new IllegalStateException("list must not be empty");
        }
        fullNode.forEach(Objects::requireNonNull);
        exclusions.stream().filter(i -> !JSonExclusions.isCorrectPath(i)).findAny().ifPresent(JSonExclusions::throwPathErrorWrongFormat);
        return exclusions.stream().noneMatch(exclusion -> JSonExclusions.isExclusionApplied(fullNode, exclusion));
    }

    private static void throwPathErrorWrongFormat(String path) {
        throw new PathError((Object)("path " + path + " has wrong format"));
    }

    private static boolean isCorrectPath(String path) {
        Objects.requireNonNull(path);
        if (path.length() < 2) {
            return false;
        }
        if (!Objects.equals(SLASH, "" + path.charAt(0))) {
            return false;
        }
        List<String> parts = JSonExclusions.getParts(path);
        if (!parts.get(0).isEmpty()) {
            return false;
        }
        if (LAST_ITEM_FILTER.test(parts.get(parts.size() - 1))) {
            return false;
        }
        for (int i = 1; i < parts.size() - 1; ++i) {
            if (!ITEM_PATTERN_FILTER.test(parts.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isExclusionApplied(List<TreeNode> fullNode, String exclusion) {
        return JSonExclusions.isExclusionApplicable(JSonExclusions.extractData(exclusion), fullNode);
    }

    private static List<String> getParts(String path) {
        String temp = path;
        ArrayList<String> parts = new ArrayList<String>();
        while (temp != null) {
            String part;
            int indexOfSlash = temp.indexOf(SLASH);
            if (indexOfSlash < 0) {
                part = temp;
                temp = null;
            } else {
                part = temp.substring(0, indexOfSlash);
                temp = temp.substring(indexOfSlash + SLASH.length(), temp.length());
            }
            parts.add(part);
        }
        return parts;
    }

    private static List<String> extractData(String path) {
        List<String> parts = JSonExclusions.getParts(path);
        parts.remove(0);
        return parts;
    }

    private static boolean isExclusionApplicable(List<String> parsedExclusions, List<TreeNode> fullNode) {
        Objects.requireNonNull(parsedExclusions);
        Objects.requireNonNull(fullNode);
        int minSize = parsedExclusions.size() < fullNode.size() ? parsedExclusions.size() : fullNode.size();
        ParentState parentState = ParentState.NOT_INITED;
        block12: for (int i = 0; i < minSize; ++i) {
            String pathItem;
            switch (pathItem = parsedExclusions.get(i)) {
                case "*": {
                    parentState = ParentState.switchTo(parentState, ParentState.ASTERIX);
                    continue block12;
                }
                case "**": {
                    parentState = ParentState.switchTo(parentState, ParentState.TWO_ASTERIX);
                    continue block12;
                }
                default: {
                    switch (parentState) {
                        case NOT_INITED: 
                        case IDENT: {
                            Object object = fullNode.get(i).object();
                            if (!(object instanceof Identity)) {
                                return false;
                            }
                            if (!((Identity)fullNode.get(i).object()).supports(SqNodeKeyType.class)) {
                                return false;
                            }
                            Identity identity = (Identity)fullNode.get(i).object();
                            if (JSonExclusions.identifies(identity, JSonExclusions.getIdentityType(pathItem), JSonExclusions.getIdentity(pathItem))) break;
                            return false;
                        }
                        case ASTERIX: 
                        case TWO_ASTERIX: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    parentState = ParentState.switchTo(parentState, ParentState.IDENT);
                }
            }
        }
        if (parsedExclusions.size() == fullNode.size()) {
            return true;
        }
        if (parsedExclusions.size() > fullNode.size()) {
            return false;
        }
        String lastExcusionElement = parsedExclusions.get(parsedExclusions.size() - 1);
        if ("**".equals(lastExcusionElement)) {
            return true;
        }
        return fullNode.size() - parsedExclusions.size() == 1 && "*".equals(lastExcusionElement);
    }

    private static boolean identifies(Identity<SqNodeKeyType> identity, SqNodeKeyType identityType, String VALUE) {
        Objects.requireNonNull(identity);
        Objects.requireNonNull(identityType);
        Objects.requireNonNull(VALUE);
        switch (identityType) {
            case monkeyId: 
            case componentType: {
                return Objects.equals(identity.ident(identityType), VALUE);
            }
        }
        throw new IllegalStateException("unknown identityType " + (Object)((Object)identityType));
    }

    private static SqNodeKeyType getIdentityType(String pathElement) {
        Objects.requireNonNull(pathElement);
        if (pathElement.length() == 0) {
            throw new IllegalStateException("pathElenent cannot be empty");
        }
        return pathElement.startsWith("@") ? SqNodeKeyType.componentType : SqNodeKeyType.monkeyId;
    }

    private static String getIdentity(String pathElenent) {
        SqNodeKeyType identityType = JSonExclusions.getIdentityType(pathElenent);
        switch (identityType) {
            case monkeyId: {
                return pathElenent;
            }
            case componentType: {
                return pathElenent.substring(1);
            }
        }
        throw new IllegalStateException("unknown type " + (Object)((Object)identityType));
    }

    private static enum ParentState {
        NOT_INITED,
        IDENT,
        ASTERIX,
        TWO_ASTERIX;


        public static ParentState switchTo(ParentState oldValue, ParentState newValue) {
            Objects.requireNonNull(oldValue);
            Objects.requireNonNull(newValue);
            return oldValue == TWO_ASTERIX ? TWO_ASTERIX : newValue;
        }
    }

    private static class CollectsFullNodeNameResult {
        private final TreeNode treeNode;
        private final List<TreeNode> fullPath;

        CollectsFullNodeNameResult(List<TreeNode> fullPath, TreeNode treeNode) {
            this.fullPath = Objects.requireNonNull(fullPath);
            this.treeNode = Objects.requireNonNull(treeNode);
            fullPath.forEach(Objects::requireNonNull);
        }

        public TreeNode treeNode() {
            return this.treeNode;
        }

        public String fullPath() {
            return this.fullPath.stream().map(TreeNode::object).map(CollectsFullNodeNameResult::objectIdentName).map(on -> JSonExclusions.SLASH + on).collect(Collectors.joining());
        }

        private static String objectIdentName(Object o) {
            if (!(o instanceof Identity)) {
                return "?";
            }
            if (!((Identity)o).supports(SqNodeKeyType.class)) {
                return "?";
            }
            Identity identity = (Identity)o;
            String identifier = identity.ident(SqNodeKeyType.monkeyId) != null ? identity.ident(SqNodeKeyType.monkeyId) : (identity.ident(SqNodeKeyType.componentType) != null ? "@" + identity.ident(SqNodeKeyType.componentType) : "?");
            return identifier;
        }
    }

    private static class ProcessedResult {
        private final boolean processed;
        private final TreeNode treeNode;

        ProcessedResult(boolean processed, TreeNode treeNode) {
            this.processed = processed;
            this.treeNode = Objects.requireNonNull(treeNode);
        }

        public boolean processed() {
            return this.processed;
        }

        public TreeNode treeNode() {
            return this.treeNode;
        }
    }
}

