/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.impl.directcomparison.flatterprocs.FlattersCommon;
import com.steammachine.jsonchecker.types.DirectValue;
import com.steammachine.jsonchecker.types.JSONMatchedParam;
import com.steammachine.jsonchecker.types.JSONParam;
import com.steammachine.jsonchecker.types.JSONParams;
import com.steammachine.jsonchecker.types.exceptions.ParamError;
import com.steammachine.jsonchecker.types.exceptions.ParamNotFound;
import com.steammachine.jsonchecker.types.exceptions.ParamTypeError;
import com.steammachine.jsonchecker.utils.compatibletypescomparator.CompatibleTypesComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class JSONParamsBuilder {
    private final List<JSONParam> params = new ArrayList<JSONParam>();

    private JSONParamsBuilder() {
    }

    public static JSONParamsBuilder of() {
        return new JSONParamsBuilder();
    }

    public <T> JSONParamsBuilder fromMap(Map<String, T> value) {
        if (value != null) {
            value.entrySet().forEach(entry -> this.single((String)entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public JSONParams build() {
        this.params.forEach(JSONParam::checkValues);
        final Map<String, JSONParam> temp = this.params.stream().collect(Collectors.toMap(JSONParam::name, e -> e, JSONParamsBuilder::alreadyDefined));
        return new JSONParams(){
            private Map<String, JSONParam> map;
            {
                this.map = temp;
            }

            @Override
            public JSONParam get(String name) {
                return this.map.computeIfAbsent(name, paramName -> {
                    throw new ParamNotFound("param " + paramName);
                });
            }

            public String toString() {
                return "JSONParams(map=" + this.map + ")";
            }
        };
    }

    public JSONParamsBuilder param(JSONParam param) {
        Objects.requireNonNull(param);
        this.params.add(param);
        return this;
    }

    public JSONParamsBuilder param(String name, JSONMatchedParam param) {
        return this.param(new JSONMatchedParamWrapper(name, param));
    }

    public JSONParamsBuilder single(String name, Object value) {
        return this.param(new SingleParam(name, value));
    }

    public JSONParamsBuilder single(String name, boolean value) {
        return this.single(name, (Object)value);
    }

    public JSONParamsBuilder single(String name, byte value) {
        return this.single(name, (Object)value);
    }

    public JSONParamsBuilder single(String name, int value) {
        return this.single(name, (Object)value);
    }

    public JSONParamsBuilder single(String name, long value) {
        return this.single(name, (Object)value);
    }

    public JSONParamsBuilder single(String name, float value) {
        return this.single(name, Float.valueOf(value));
    }

    public JSONParamsBuilder single(String name, double value) {
        return this.single(name, (Object)value);
    }

    public JSONParamsBuilder regexp(String name, Pattern regexp) {
        return this.param(new RegexpMatcherParam(name, regexp));
    }

    public JSONParamsBuilder regexp(String name, String regexp) {
        return this.param(new RegexpMatcherParam(name, regexp));
    }

    private static JSONParam alreadyDefined(JSONParam param, JSONParam param2) {
        return param2;
    }

    private static class RegexpMatcherParam
    implements JSONParam {
        private final Pattern pattern;
        private final String name;
        private final String regexp;

        private RegexpMatcherParam(String name, String regexp) {
            this.name = name;
            this.regexp = Objects.requireNonNull(regexp);
            this.pattern = RegexpMatcherParam.loadTregExp(regexp);
        }

        private RegexpMatcherParam(String name, Pattern regexp) {
            this.name = name;
            this.pattern = Objects.requireNonNull(regexp);
            this.regexp = regexp.pattern();
        }

        private static Pattern loadTregExp(String regexp) {
            try {
                return Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String paramsRep() {
            return this.regexp;
        }

        @Override
        public void checkValues() {
            if (this.pattern == null) {
                throw new ParamError("pattern is not valid. " + this.regexp);
            }
        }

        @Override
        public boolean matches(Object value) {
            return value instanceof String && this.pattern.matcher((CharSequence)String.class.cast(value)).matches();
        }

        @Override
        public boolean matchesParam(JSONParam thatParam) {
            return false;
        }
    }

    private static class SingleParam
    implements JSONParam,
    DirectValue {
        private final Object value;
        private final String name;

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String paramsRep() {
            return "" + this.value;
        }

        public SingleParam(String name, Object value) {
            this.name = Objects.requireNonNull(name);
            this.value = value;
        }

        @Override
        public void checkValues() {
            CommonUtils.check(() -> FlattersCommon.isFlatValue(this.value), () -> new ParamTypeError("VALUE " + this.value + " has wrong type " + this.value.getClass().getName()));
        }

        @Override
        public boolean matches(Object value) {
            return CompatibleTypesComparator.compatibleEquals(this.value, value);
        }

        @Override
        public boolean matchesParam(JSONParam thatParam) {
            return thatParam instanceof SingleParam && CompatibleTypesComparator.compatibleEquals(((SingleParam)thatParam).value, this.value);
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    private static class JSONMatchedParamWrapper
    implements JSONParam {
        private final JSONMatchedParam matchedParam;
        private final String name;

        private JSONMatchedParamWrapper(String name, JSONMatchedParam matchedParam) {
            this.name = Objects.requireNonNull(name);
            this.matchedParam = Objects.requireNonNull(matchedParam);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String paramsRep() {
            return "JSONMatchedParam";
        }

        @Override
        public void checkValues() {
        }

        @Override
        public boolean matches(Object value) {
            return this.matchedParam.matches(value);
        }

        @Override
        public boolean matchesParam(JSONParam thatParam) {
            return false;
        }
    }
}

