/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.flatter2;

import com.steammachine.jsonchecker.impl.flatter2.IdentifierType;
import java.util.Objects;

public final class Id {
    private final IdentifierType type;
    private final String id;
    private final Integer index;

    private Id(String id, Integer index, IdentifierType type) {
        Objects.requireNonNull(type);
        switch (type) {
            case notArrayItem: {
                Objects.requireNonNull(id);
                break;
            }
            case arrayItem: {
                Objects.requireNonNull(index);
                break;
            }
            case anyArrayItem: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.id = id;
        this.index = index;
        this.type = type;
    }

    public static Id obj(String name) {
        return new Id(name, null, IdentifierType.notArrayItem);
    }

    public static Id arr(int index) {
        return new Id(null, index, IdentifierType.arrayItem);
    }

    public static Id anyArr() {
        return new Id(null, null, IdentifierType.anyArrayItem);
    }

    public String id() {
        return this.id;
    }

    public Integer index() {
        return this.index;
    }

    public IdentifierType type() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case notArrayItem: {
                return "Id(" + this.id + ")";
            }
            case arrayItem: {
                return "Id [" + this.index() + "]";
            }
            case anyArrayItem: {
                return "Id [*]";
            }
        }
        throw new IllegalStateException("illegal type " + (Object)((Object)this.type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Id)) {
            return false;
        }
        Id id1 = (Id)o;
        if (this.type != id1.type) {
            return false;
        }
        if (this.id != null ? !this.id.equals(id1.id) : id1.id != null) {
            return false;
        }
        return this.index != null ? this.index.equals(id1.index) : id1.index == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        return result;
    }
}

