/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.directcomparison.pathformats;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.PathApplication;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.PathFormat;
import com.steammachine.jsonchecker.types.Path;
import com.steammachine.jsonchecker.types.exceptions.PathError;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonkeyIdCompTypeFormat
implements PathFormat {
    private static final String L = Pattern.quote("[");
    private static final String R = Pattern.quote("]");
    private static final String AST = Pattern.quote("*");
    private static final String SEMICOLON = Pattern.quote(":");
    private static final String PART = "([/](([@]?(([\\w]|[:])+))|(" + L + "[0-9]+" + R + ")|(" + AST + "{1,2})|(" + L + AST + R + ")))";
    private static final Predicate<String> FORMAT_TEMPLATE = Pattern.compile("^((" + AST + "){2,3})?" + PART + "+$").asPredicate();
    private static final Pattern PART_TEMPLATE = Pattern.compile(PART);

    @Override
    public String name() {
        return "MONKEY";
    }

    @Override
    public boolean checkPathFormat(String path) {
        return FORMAT_TEMPLATE.test(path);
    }

    @Override
    public Path parsePath(String path) {
        String processedPath;
        CommonUtils.check(() -> this.checkPathFormat(path), () -> new PathError((Object)("" + path + " is not correct path")));
        Path.Builder builder = Path.builder();
        if (path.startsWith("***")) {
            processedPath = path.substring("***".length());
            builder.ast().ast().ast();
        } else if (path.startsWith("**")) {
            processedPath = path.substring("**".length());
            builder.ast().ast();
        } else {
            processedPath = path;
        }
        Matcher matcher = PART_TEMPLATE.matcher(processedPath);
        while (matcher.find()) {
            String part = processedPath.substring(matcher.start(), matcher.end()).substring(1);
            builder.del();
            if (part.startsWith("[")) {
                String d = processedPath;
                String p = part;
                CommonUtils.check(() -> p.endsWith("]"), () -> new PathError((Object)("" + d + " is not valid path")));
                part = part.substring(1, part.length() - 1);
                if ("*".equals(part)) {
                    builder.anyArr();
                    continue;
                }
                builder.arr(Integer.parseInt(part));
                continue;
            }
            if (part.startsWith("@")) {
                builder.obj(part);
                continue;
            }
            if ("**".equals(part)) {
                builder.ast().ast();
                continue;
            }
            if ("*".equals(part)) {
                builder.ast();
                continue;
            }
            builder.obj(part);
        }
        return builder.get();
    }

    @Override
    public boolean isApplied(Path path, Path templatePath) {
        return PathApplication.isPathApplied(path, templatePath);
    }
}

