/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.examples;

import com.steammachine.common.utils.ResourceUtils;
import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.types.JSONParams;
import com.steammachine.jsonchecker.types.NodeCheckResult;
import com.steammachine.jsonchecker.utils.JSONParamsBuilder;
import com.steammachine.jsonchecker.utils.JSonDirectComparator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Examples {
    private static final Logger LOG = LoggerFactory.getLogger(Examples.class);

    public static void main(String ... args) throws IOException {
        Examples.simpleJsonComparison();
        Examples.simpleJsonDataComparison();
        Examples.comparisonWithParams();
        Examples.comparisonWithIncusion();
    }

    private static void comparisonWithIncusion() throws IOException {
        try (InputStream data1 = Examples.dataStream("resources/resource_json1.json");
             InputStream data2 = Examples.dataStream("resources/resource_json5.json");){
            NodeCheckResult result = JSonDirectComparator.compareJSonStreams(data1, data2, null, Arrays.asList("param1", "param3", "param4[0]"), null);
            LOG.info("comparison result =   {0}", (Object)result);
            CommonUtils.check(result::isSuccessful, IllegalStateException::new);
        }
    }

    private static void comparisonWithParams() throws IOException {
        NodeCheckResult result;
        JSONParams params2;
        Throwable throwable;
        InputStream data2;
        try (InputStream data1 = Examples.dataStream("resources/resource_json1.json");){
            data2 = Examples.dataStream("resources/resource_json4.json");
            throwable = null;
            try {
                params2 = JSONParamsBuilder.of().single("p2", false).build();
                result = JSonDirectComparator.compareJSonStreams(data1, data2, params2, null, null);
                LOG.info("comparison result =   {0}", (Object)result);
                CommonUtils.check(result::isSuccessful, IllegalStateException::new);
            }
            catch (Throwable params2) {
                throwable = params2;
                throw params2;
            }
            finally {
                if (data2 != null) {
                    if (throwable != null) {
                        try {
                            data2.close();
                        }
                        catch (Throwable params2) {
                            throwable.addSuppressed(params2);
                        }
                    } else {
                        data2.close();
                    }
                }
            }
        }
        data1 = Examples.dataStream("resources/resource_json1.json");
        var1_1 = null;
        try {
            data2 = Examples.dataStream("resources/resource_json4.json");
            throwable = null;
            try {
                params2 = JSONParamsBuilder.of().single("p2", true).build();
                result = JSonDirectComparator.compareJSonStreams(data1, data2, params2, null, null);
                LOG.info("comparison result =  {0}", (Object)result);
                LOG.info("comparison result.messages =  {0}", result.messages());
                CommonUtils.check(() -> !result.isSuccessful(), IllegalStateException::new);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (data2 != null) {
                    if (throwable != null) {
                        try {
                            data2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        data2.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var1_1 = throwable4;
            throw throwable4;
        }
        finally {
            if (data1 != null) {
                if (var1_1 != null) {
                    try {
                        data1.close();
                    }
                    catch (Throwable throwable5) {
                        var1_1.addSuppressed(throwable5);
                    }
                } else {
                    data1.close();
                }
            }
        }
    }

    private static void simpleJsonDataComparison() throws IOException {
        boolean result2;
        Throwable throwable;
        InputStream data2;
        try (InputStream data1 = Examples.dataStream("resources/resource_json1.json");){
            data2 = Examples.dataStream("resources/resource_json2.json");
            throwable = null;
            try {
                result2 = JSonDirectComparator.compareJSonStreams(data1, data2);
                LOG.info("comparison result =  {0}", (Object)result2);
                CommonUtils.check(() -> !result2, IllegalStateException::new);
            }
            catch (Throwable result2) {
                throwable = result2;
                throw result2;
            }
            finally {
                if (data2 != null) {
                    if (throwable != null) {
                        try {
                            data2.close();
                        }
                        catch (Throwable result2) {
                            throwable.addSuppressed(result2);
                        }
                    } else {
                        data2.close();
                    }
                }
            }
        }
        data1 = Examples.dataStream("resources/resource_json1.json");
        var1_1 = null;
        try {
            data2 = Examples.dataStream("resources/resource_json3.json");
            throwable = null;
            try {
                result2 = JSonDirectComparator.compareJSonStreams(data1, data2);
                LOG.info("comparison result is {0}", (Object)result2);
                CommonUtils.check(() -> result2, IllegalStateException::new);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (data2 != null) {
                    if (throwable != null) {
                        try {
                            data2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        data2.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var1_1 = throwable4;
            throw throwable4;
        }
        finally {
            if (data1 != null) {
                if (var1_1 != null) {
                    try {
                        data1.close();
                    }
                    catch (Throwable throwable5) {
                        var1_1.addSuppressed(throwable5);
                    }
                } else {
                    data1.close();
                }
            }
        }
    }

    private static void simpleJsonComparison() {
        boolean result = JSonDirectComparator.compareJSonStrings("{\"d\": 11}", "{   }");
        LOG.info("comparison result = {0}", (Object)result);
        CommonUtils.check(() -> !result, IllegalStateException::new);
        boolean result2 = JSonDirectComparator.compareJSonStrings("{\"d\": 11, \"f\": 21}", "{\"f\": 21, \"d\": 11 }");
        LOG.info("comparison result = {0}", (Object)result);
        CommonUtils.check(() -> result2, IllegalStateException::new);
    }

    private static InputStream dataStream(String path) {
        return ResourceUtils.loadResourceByRelativePath(Examples.class, (String)path);
    }
}

