/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2;

import com.steammachine.common.utils.commonutils.CommonUtils;
import com.steammachine.jsonchecker.utils.compatibletypescomparator.ver2.CompareTo;
import java.util.Arrays;
import java.util.Objects;

public class Comparators {
    private static final Class[] INTS = new Class[]{Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE};
    private static final Class[] FLOATS = new Class[]{Float.class, Float.TYPE, Double.class, Double.TYPE};
    public static final CompareTo<Object, Object> NEVER_COMPARED = new CompareTo<Object, Object>(){

        @Override
        public Class<Object> type1() {
            return Object.class;
        }

        @Override
        public Class<Object> type2() {
            return Object.class;
        }

        @Override
        public boolean isEqualTo(Object value1, Object value2) {
            return false;
        }

        public String toString() {
            return "NEVER COMPARED";
        }
    };

    private Comparators() {
    }

    private static boolean compareInts(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o2 != null && Comparators.toLong(o1) == Comparators.toLong(o2);
    }

    private static boolean compareFloats(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o2 != null && Objects.equals(Comparators.toDoubleString(o1), Comparators.toDoubleString(o2));
    }

    private static String toDoubleString(Object o) {
        if (o.getClass() == Double.class || o.getClass() == Double.TYPE) {
            return "" + o;
        }
        if (o.getClass() == Float.class || o.getClass() == Float.TYPE) {
            return "" + (double)((Float)o).floatValue();
        }
        throw new IllegalStateException();
    }

    private static long toLong(Object o) {
        if (o.getClass() == Long.class || o.getClass() == Long.TYPE) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class || o.getClass() == Integer.TYPE) {
            return ((Integer)o).intValue();
        }
        if (o.getClass() == Short.class || o.getClass() == Short.TYPE) {
            return ((Short)o).shortValue();
        }
        if (o.getClass() == Byte.class || o.getClass() == Byte.TYPE) {
            return ((Byte)o).byteValue();
        }
        throw new IllegalStateException();
    }

    private static boolean isInt(Class clazz) {
        return Arrays.stream(INTS).anyMatch(c -> c == clazz);
    }

    private static boolean isFloat(Class clazz) {
        return Arrays.stream(FLOATS).anyMatch(c -> c == clazz);
    }

    public static class BooleanTypesComparator<T1, T2>
    implements CompareTo<T1, T2> {
        private final Class<T1> type1;
        private final Class<T2> type2;

        public BooleanTypesComparator(Class<T1> type1, Class<T2> type2) {
            CommonUtils.check(() -> type1 == Boolean.TYPE || type1 == Boolean.class, IllegalStateException::new);
            CommonUtils.check(() -> type2 == Boolean.TYPE || type2 == Boolean.class, IllegalStateException::new);
            this.type1 = Objects.requireNonNull(type1);
            this.type2 = Objects.requireNonNull(type2);
        }

        @Override
        public Class<T1> type1() {
            return this.type1;
        }

        @Override
        public Class<T2> type2() {
            return this.type2;
        }

        @Override
        public boolean isEqualTo(T1 value1, T2 value2) {
            return BooleanTypesComparator.compareBooleans(value1, value2);
        }

        private static boolean compareBooleans(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            return o1 != null && o2 != null && BooleanTypesComparator.toBoolean(o1) == BooleanTypesComparator.toBoolean(o2);
        }

        private static boolean toBoolean(Object o) {
            if (o.getClass() == Boolean.class || o.getClass() == Boolean.TYPE) {
                return (Boolean)o;
            }
            throw new IllegalStateException();
        }
    }

    public static class CharacterTypesComparator<T1, T2>
    implements CompareTo<T1, T2> {
        private final Class<T1> type1;
        private final Class<T2> type2;

        public CharacterTypesComparator(Class<T1> type1, Class<T2> type2) {
            CommonUtils.check(() -> type1 == Character.TYPE || type1 == Character.class, IllegalStateException::new);
            CommonUtils.check(() -> type2 == Character.TYPE || type2 == Character.class, IllegalStateException::new);
            this.type1 = Objects.requireNonNull(type1);
            this.type2 = Objects.requireNonNull(type2);
        }

        @Override
        public Class<T1> type1() {
            return this.type1;
        }

        @Override
        public Class<T2> type2() {
            return this.type2;
        }

        @Override
        public boolean isEqualTo(T1 value1, T2 value2) {
            return CharacterTypesComparator.compareChars(value1, value2);
        }

        private static boolean compareChars(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            return o1 != null && o2 != null && CharacterTypesComparator.toChars(o1) == CharacterTypesComparator.toChars(o2);
        }

        private static char toChars(Object o) {
            if (o.getClass() == Character.class || o.getClass() == Character.TYPE) {
                return ((Character)o).charValue();
            }
            throw new IllegalStateException();
        }
    }

    public static class IntFloatTypesComparator<T1, T2>
    implements CompareTo<T1, T2> {
        private final Class<T1> type1 = (Class)CommonUtils.check(() -> type1, t -> Comparators.isInt(t) || Comparators.isFloat(t), IllegalStateException::new);
        private final Class<T2> type2 = (Class)CommonUtils.check(() -> type2, t -> Comparators.isInt(t) || Comparators.isFloat(t), IllegalStateException::new);

        public IntFloatTypesComparator(Class<T1> type1, Class<T2> type2) {
        }

        @Override
        public Class<T1> type1() {
            return this.type1;
        }

        @Override
        public Class<T2> type2() {
            return this.type2;
        }

        @Override
        public boolean isEqualTo(T1 value1, T2 value2) {
            return IntFloatTypesComparator.compareIntsAndFloat(value1, value2);
        }

        private static boolean compareIntsAndFloat(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null != (o2 == null)) {
                return false;
            }
            if (Comparators.isInt(o1.getClass()) && Comparators.isInt(o2.getClass())) {
                return Comparators.compareInts(o1, o2);
            }
            if (Comparators.isFloat(o1.getClass()) && Comparators.isFloat(o2.getClass())) {
                return Comparators.compareFloats(o1, o2);
            }
            if (Comparators.isInt(o1.getClass()) && Comparators.isFloat(o2.getClass())) {
                return Objects.equals(IntFloatTypesComparator.normalizedNumString(o1), IntFloatTypesComparator.normalizedNumString(o2));
            }
            if (Comparators.isFloat(o1.getClass()) && Comparators.isInt(o2.getClass())) {
                return Objects.equals(IntFloatTypesComparator.normalizedNumString(o1), IntFloatTypesComparator.normalizedNumString(o2));
            }
            throw new IllegalStateException();
        }

        private static String normalizedNumString(Object o) {
            Objects.requireNonNull(o);
            CommonUtils.check(() -> Comparators.isInt(o.getClass()) || Comparators.isFloat(o.getClass()), IllegalStateException::new);
            if (Comparators.isInt(o.getClass())) {
                return "" + Comparators.toLong(o);
            }
            if (Comparators.isFloat(o.getClass())) {
                double d = IntFloatTypesComparator.toDouble(o);
                if (IntFloatTypesComparator.isFrac(d)) {
                    return Comparators.toDoubleString(o);
                }
                return "" + Comparators.toLong(IntFloatTypesComparator.wholePart(d));
            }
            throw new IllegalStateException();
        }

        private static long wholePart(double d) {
            return (long)d;
        }

        private static boolean isFrac(double d) {
            return d % 1.0 != 0.0;
        }

        private static double toDouble(Object o) {
            if (o.getClass() == Double.class || o.getClass() == Double.TYPE) {
                return (Double)o;
            }
            if (o.getClass() == Float.class || o.getClass() == Float.TYPE) {
                return ((Float)o).floatValue();
            }
            throw new IllegalStateException();
        }
    }

    public static class FloatTypesComparator<T1, T2>
    implements CompareTo<T1, T2> {
        private final Class<T1> type1 = (Class)CommonUtils.check(() -> type1, x$0 -> Comparators.access$300(x$0), IllegalStateException::new);
        private final Class<T2> type2 = (Class)CommonUtils.check(() -> type2, x$0 -> Comparators.access$300(x$0), IllegalStateException::new);

        public FloatTypesComparator(Class<T1> type1, Class<T2> type2) {
        }

        @Override
        public Class<T1> type1() {
            return this.type1;
        }

        @Override
        public Class<T2> type2() {
            return this.type2;
        }

        @Override
        public boolean isEqualTo(T1 value1, T2 value2) {
            return Comparators.compareFloats(value1, value2);
        }
    }

    public static class IntegerTypesComparator<T1, T2>
    implements CompareTo<T1, T2> {
        private final Class<T1> type1 = (Class)CommonUtils.check(() -> type1, x$0 -> Comparators.access$100(x$0), IllegalStateException::new);
        private final Class<T2> type2 = (Class)CommonUtils.check(() -> type2, x$0 -> Comparators.access$100(x$0), IllegalStateException::new);

        public IntegerTypesComparator(Class<T1> type1, Class<T2> type2) {
        }

        @Override
        public Class<T1> type1() {
            return this.type1;
        }

        @Override
        public Class<T2> type2() {
            return this.type2;
        }

        @Override
        public boolean isEqualTo(T1 value1, T2 value2) {
            return Comparators.compareInts(value1, value2);
        }
    }

    public static class SameTypeComparator<T>
    implements CompareTo<T, T> {
        private final Class<T> t;

        public SameTypeComparator(Class<T> t) {
            this.t = Objects.requireNonNull(t);
        }

        @Override
        public Class<T> type1() {
            return this.t;
        }

        @Override
        public Class<T> type2() {
            return this.t;
        }

        @Override
        public boolean isEqualTo(T value1, T value2) {
            return Objects.equals(value1, value2);
        }
    }
}

