/*
 * Decompiled with CFR 0.152.
 */
package other.methodfinder;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClassMethodTable {
    private static final SourceCodePosition NO_POSITION = new DefaultSourceCodePosition(-1);

    public static Map<String, SourceCodePosition> readClassFromInputStream(InputStream data) throws IOException {
        return ClassMethodTable.readClassFromDataInputStream(new DataInputStream(data));
    }

    public static String methodSignature(Method method) {
        Objects.requireNonNull(method);
        StringBuilder builder = new StringBuilder();
        builder.append(method.getReturnType().getTypeName());
        builder.append(" ");
        builder.append(method.getName());
        builder.append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            builder.append(parameterTypes[i].getTypeName());
            if (i >= parameterTypes.length - 1) continue;
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }

    protected static Map<String, SourceCodePosition> readClassFromDataInputStream(DataInputStream data) throws IOException {
        int attributesCount;
        if (data.readInt() != -889275714) {
            throw new IllegalStateException(" is not a Java .class file");
        }
        HashMap<String, SourceCodePosition> result = new HashMap<String, SourceCodePosition>();
        data.readUnsignedShort();
        data.readUnsignedShort();
        int constCount = data.readUnsignedShort();
        Const[] c = new Const[constCount];
        block16: for (int i = 1; i < constCount; ++i) {
            byte tag = data.readByte();
            switch (tag) {
                case 7: {
                    data.readUnsignedShort();
                    continue block16;
                }
                case 9: {
                    ClassMethodTable.skipBytes(data, 4);
                    continue block16;
                }
                case 10: {
                    c[i] = new CONSTANT_METHODREF_Info(tag, data.readUnsignedShort(), data.readUnsignedShort());
                    continue block16;
                }
                case 11: {
                    c[i] = new CONSTANT_INTERFACEMETHODREF_Info(tag, data.readUnsignedShort(), data.readUnsignedShort());
                    continue block16;
                }
                case 8: {
                    c[i] = new Constant_String_Info(tag, data.readUnsignedShort());
                    continue block16;
                }
                case 3: {
                    ClassMethodTable.skipBytes(data, 4);
                    continue block16;
                }
                case 4: {
                    ClassMethodTable.skipBytes(data, 4);
                    continue block16;
                }
                case 5: {
                    ++i;
                    ClassMethodTable.skipBytes(data, 8);
                    continue block16;
                }
                case 6: {
                    ++i;
                    ClassMethodTable.skipBytes(data, 8);
                    continue block16;
                }
                case 12: {
                    c[i] = new CONSTANT_NAMEANDTYPE_Info(tag, data.readUnsignedShort(), data.readUnsignedShort());
                    continue block16;
                }
                case 1: {
                    c[i] = new Constant_Utf8_Info(tag, data.readUTF());
                    continue block16;
                }
                case 15: {
                    c[i] = new CONSTANT_METHODHANDLE_Info(tag, data.readUnsignedByte(), data.readUnsignedShort());
                    continue block16;
                }
                case 16: {
                    c[i] = new CONSTANT_METHODTYPE_Info(tag, data.readUnsignedShort());
                    continue block16;
                }
                case 18: {
                    ClassMethodTable.skipBytes(data, 4);
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Invalid byte tag in constant pool: " + tag);
                }
            }
        }
        ClassMethodTable.skipBytes(data, 2);
        data.readUnsignedShort();
        data.readUnsignedShort();
        int interfaceCount = data.readUnsignedShort();
        for (int i = 0; i < interfaceCount; ++i) {
            data.readUnsignedShort();
        }
        int fieldCount = data.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            data.readUnsignedShort();
            data.readUnsignedShort();
            data.readUnsignedShort();
            attributesCount = data.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                data.readUnsignedShort();
                ClassMethodTable.skipAttribute(data);
            }
        }
        int methodCount = data.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            data.readUnsignedShort();
            String methodName = ClassMethodTable.stringDataInfo(data.readUnsignedShort(), c);
            String dataInfo = ClassMethodTable.stringDataInfo(data.readUnsignedShort(), c);
            String methodSignature = ClassMethodTable.parseMethodDescriptor(methodName, dataInfo);
            SourceCodePosition position = NO_POSITION;
            int attributesCount2 = data.readUnsignedShort();
            for (int j = 0; j < attributesCount2; ++j) {
                String attributeName = ClassMethodTable.stringDataInfo(data.readUnsignedShort(), c);
                if ("Code".equals(attributeName)) {
                    position = ClassMethodTable.readCodeAttribute(data, i, c);
                    continue;
                }
                ClassMethodTable.skipAttribute(data);
            }
            result.put(methodSignature, position);
        }
        attributesCount = data.readUnsignedShort();
        for (int j = 0; j < attributesCount; ++j) {
            ClassMethodTable.stringDataInfo(data.readUnsignedShort(), c);
            ClassMethodTable.skipAttribute(data);
        }
        return result;
    }

    private static void skipBytes(DataInputStream data, int attribute_length) throws IOException {
        while (attribute_length > 0) {
            int skippedBytes = data.skipBytes(attribute_length);
            attribute_length -= skippedBytes;
        }
    }

    private static String stringDataInfo(int constantIndex, Const[] consts) {
        if (constantIndex < 0 || constantIndex >= consts.length) {
            throw new IllegalStateException("illegal interface index : " + constantIndex);
        }
        if (consts[constantIndex] == null) {
            throw new IllegalStateException("consts[" + constantIndex + "] == null");
        }
        if (consts[constantIndex].tag != 1) {
            throw new IllegalStateException("");
        }
        Constant_Utf8_Info utf8_info = (Constant_Utf8_Info)consts[constantIndex];
        return utf8_info.data;
    }

    private static SourceCodePosition readCodeAttribute(DataInputStream data, int order, Const[] c) throws IOException {
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        ClassMethodTable.skipBytes(data, 4);
        ClassMethodTable.skipBytes(data, 2);
        ClassMethodTable.skipBytes(data, 2);
        int code_length = data.readInt();
        byte[] codeBytes = new byte[code_length];
        data.readFully(codeBytes);
        int exception_table_length = data.readUnsignedShort();
        for (int i = 0; i < exception_table_length; ++i) {
            ClassMethodTable.skipBytes(data, 2);
            ClassMethodTable.skipBytes(data, 2);
            ClassMethodTable.skipBytes(data, 2);
            ClassMethodTable.skipBytes(data, 2);
        }
        SourceCodePosition result = NO_POSITION;
        int attributes_count = data.readUnsignedShort();
        for (int j = 0; j < attributes_count; ++j) {
            String attributeName = ClassMethodTable.stringDataInfo(data.readUnsignedShort(), c);
            if ("LineNumberTable".equals(attributeName)) {
                result = ClassMethodTable.readCodeOrder(data, order);
                continue;
            }
            ClassMethodTable.skipAttribute(data);
        }
        return result;
    }

    private static SourceCodePosition readCodeOrder(DataInputStream data, int order) throws IOException {
        ClassMethodTable.skipBytes(data, 4);
        int line_number_table_length = data.readUnsignedShort();
        Integer minLine = null;
        Integer maxLine = null;
        for (int k = 0; k < line_number_table_length; ++k) {
            data.readUnsignedShort();
            int lineNumber = data.readUnsignedShort();
            ClassMethodTable.skipBytes(data, 0);
            if (minLine == null) {
                minLine = lineNumber;
            }
            if (maxLine == null) {
                maxLine = lineNumber;
            }
            if (lineNumber < minLine) {
                minLine = lineNumber;
            }
            if (lineNumber <= maxLine) continue;
            maxLine = lineNumber;
        }
        DefaultSourceCodePosition info = line_number_table_length > 0 ? new DefaultSourceCodePosition((Integer)Objects.requireNonNull(minLine), (Integer)Objects.requireNonNull(maxLine), order) : new DefaultSourceCodePosition(order);
        return info;
    }

    private static void skipAttribute(DataInputStream data) throws IOException {
        int skippedBytes;
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        for (int attribute_length = data.readInt(); attribute_length > 0; attribute_length -= skippedBytes) {
            skippedBytes = data.skipBytes(attribute_length);
        }
    }

    private static String parseTypeName(String typeName, boolean returnType) {
        String type;
        if (typeName == null) {
            throw new NullPointerException("typeName is null");
        }
        int dimensions = 0;
        for (int i = 0; i < typeName.length() && typeName.charAt(i) == '['; ++i) {
            ++dimensions;
        }
        if (dimensions >= typeName.length()) {
            throw new IllegalStateException("illegal state string");
        }
        switch (typeName.charAt(dimensions)) {
            case 'B': {
                type = "byte";
                break;
            }
            case 'C': {
                type = "char";
                break;
            }
            case 'D': {
                type = "double";
                break;
            }
            case 'F': {
                type = "float";
                break;
            }
            case 'I': {
                type = "int";
                break;
            }
            case 'J': {
                type = "long";
                break;
            }
            case 'L': {
                int lastIndexOf = typeName.lastIndexOf(";");
                if (lastIndexOf != typeName.length() - 1) {
                    throw new IllegalStateException("wrong type format " + typeName);
                }
                type = typeName.substring(dimensions + 1, lastIndexOf).replace('/', '.');
                break;
            }
            case 'S': {
                type = "short";
                break;
            }
            case 'Z': {
                type = "boolean";
                break;
            }
            case 'V': {
                if (!returnType) {
                    throw new IllegalStateException("illegal param type");
                }
                type = "void";
                break;
            }
            default: {
                throw new IllegalStateException("illegal type " + typeName.charAt(dimensions));
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(type);
        for (int i = 0; i < dimensions; ++i) {
            result.append("[]");
        }
        return "" + result;
    }

    protected static String parseMethodDescriptor(String methodName, String methodDesc) {
        int newIndex;
        int endParamIndex;
        if (methodDesc == null) {
            throw new NullPointerException("methodDescriptor is null");
        }
        int startParamIndex = methodDesc.indexOf("(");
        if (startParamIndex >= (endParamIndex = methodDesc.lastIndexOf(")"))) {
            throw new IllegalStateException("illegal methodDescriptor " + methodDesc);
        }
        String returnType = ClassMethodTable.parseTypeName(methodDesc.substring(endParamIndex + 1, methodDesc.length()), true);
        String restDesc = methodDesc.substring(startParamIndex + 1, endParamIndex);
        int index = 0;
        StringBuilder builder = new StringBuilder();
        builder.append(returnType);
        builder.append(" ");
        builder.append(methodName);
        builder.append("(");
        while ((newIndex = ClassMethodTable.nextIndex(restDesc, index)) > 0) {
            builder.append(ClassMethodTable.parseTypeName(restDesc.substring(index, newIndex), false));
            index = newIndex;
            if (ClassMethodTable.nextIndex(restDesc, index) <= 0) continue;
            builder.append(",");
        }
        builder.append(")");
        return "" + builder;
    }

    private static int nextIndex(String type, int index) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        block5: while (index < type.length()) {
            switch (type.charAt(index)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    return ++index;
                }
                case 'L': {
                    index = type.indexOf(";", index);
                    if (index == -1) {
                        throw new IllegalStateException("illegal methodDescriptor " + type);
                    }
                    return ++index;
                }
                case '[': {
                    ++index;
                    continue block5;
                }
            }
            throw new IllegalStateException("illegal methodDescriptor " + type);
        }
        return -1;
    }

    private static class Constant_InvokeDynamic
    extends Const {
        private final int bootstrap_method_attr_index;
        private final int name_and_type_index;

        private Constant_InvokeDynamic(byte tag, int bootstrap_method_attr_index, int name_and_type_index) {
            super(tag);
            this.bootstrap_method_attr_index = bootstrap_method_attr_index;
            this.name_and_type_index = name_and_type_index;
        }
    }

    private static class CONSTANT_METHODTYPE_Info
    extends Const {
        private final int descriptor_index;

        private CONSTANT_METHODTYPE_Info(byte tag, int descriptor_index) {
            super(tag);
            this.descriptor_index = descriptor_index;
        }
    }

    private static class CONSTANT_METHODHANDLE_Info
    extends Const {
        private final int reference_kind;
        private final int reference_index;

        private CONSTANT_METHODHANDLE_Info(byte tag, int reference_kind, int reference_index) {
            super(tag);
            this.reference_kind = reference_kind;
            this.reference_index = reference_index;
        }
    }

    private static class Constant_Utf8_Info
    extends Const {
        private final String data;

        private Constant_Utf8_Info(byte tag, String data) {
            super(tag);
            this.data = data;
        }
    }

    private static class CONSTANT_NAMEANDTYPE_Info
    extends Const {
        private final int name_index;
        private final int descriptor_index;

        private CONSTANT_NAMEANDTYPE_Info(byte tag, int name_index, int descriptor_index) {
            super(tag);
            this.name_index = name_index;
            this.descriptor_index = descriptor_index;
        }
    }

    private static class Constant_String_Info
    extends Const {
        private final int string_index;

        private Constant_String_Info(byte tag, int string_index) {
            super(tag);
            this.string_index = string_index;
        }
    }

    private static class CONSTANT_INTERFACEMETHODREF_Info
    extends Const {
        private final int class_index;
        private final int name_and_type_index;

        private CONSTANT_INTERFACEMETHODREF_Info(byte tag, int class_index, int name_and_type_index) {
            super(tag);
            this.class_index = class_index;
            this.name_and_type_index = name_and_type_index;
        }
    }

    private static class CONSTANT_METHODREF_Info
    extends Const {
        private final int class_index;
        private final int name_and_type_index;

        private CONSTANT_METHODREF_Info(byte tag, int class_index, int name_and_type_index) {
            super(tag);
            this.class_index = class_index;
            this.name_and_type_index = name_and_type_index;
        }
    }

    private static class Const {
        private final byte tag;

        private Const(byte tag) {
            this.tag = tag;
        }
    }

    private static class CCIC {
        public static final int CLASS_MAGIC_NUMBER = -889275714;
        public static final byte CONSTANT_UTF8 = 1;
        public static final byte CONSTANT_INTEGER = 3;
        public static final byte CONSTANT_FLOAT = 4;
        public static final byte CONSTANT_LONG = 5;
        public static final byte CONSTANT_DOUBLE = 6;
        public static final byte CONSTANT_CLASS = 7;
        public static final byte CONSTANT_STRING = 8;
        public static final byte CONSTANT_FIELDREF = 9;
        public static final byte CONSTANT_METHODREF = 10;
        public static final byte CONSTANT_INTERFACEMETHODREF = 11;
        public static final byte CONSTANT_NAMEANDTYPE = 12;
        public static final byte CONSTANT_METHODHANDLE = 15;
        public static final byte CONSTANT_METHODTYPE = 16;
        public static final byte CONSTANT_INVOKEDYNAMIC = 18;

        private CCIC() {
        }
    }

    public static class DefaultSourceCodePosition
    implements SourceCodePosition {
        private final int minLine;
        private final int maxLine;
        private final int order;
        private final boolean hasPosition;

        public DefaultSourceCodePosition(int minLine, int maxLine, int order, boolean hasPosition) {
            this.minLine = minLine;
            this.maxLine = maxLine;
            this.order = order;
            this.hasPosition = hasPosition;
        }

        public DefaultSourceCodePosition(int order) {
            this.minLine = -1;
            this.maxLine = -1;
            this.order = order;
            this.hasPosition = false;
        }

        public DefaultSourceCodePosition(int minLine, int maxLine, int order) {
            this(minLine, maxLine, order, true);
        }

        @Override
        public int minLine() {
            return this.minLine;
        }

        @Override
        public int maxLine() {
            return this.maxLine;
        }

        @Override
        public int order() {
            return this.order;
        }

        @Override
        public boolean hasPosition() {
            return this.hasPosition;
        }

        @Override
        public boolean inlinerange(int line) {
            return this.hasPosition() && line >= this.minLine() && line <= this.maxLine();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultSourceCodePosition)) {
                return false;
            }
            DefaultSourceCodePosition that = (DefaultSourceCodePosition)o;
            if (this.minLine != that.minLine) {
                return false;
            }
            if (this.maxLine != that.maxLine) {
                return false;
            }
            if (this.order != that.order) {
                return false;
            }
            return this.hasPosition == that.hasPosition;
        }

        public int hashCode() {
            int result = this.minLine;
            result = 31 * result + this.maxLine;
            result = 31 * result + this.order;
            result = 31 * result + (this.hasPosition ? 1 : 0);
            return result;
        }

        public String toString() {
            return "DefaultSourceCodePosition{minLine=" + this.minLine + ", maxLine=" + this.maxLine + ", order=" + this.order + ", hasPosition=" + this.hasPosition + '}';
        }
    }

    public static interface SourceCodePosition {
        public int minLine();

        public int maxLine();

        public int order();

        public boolean hasPosition();

        public boolean inlinerange(int var1);
    }
}

