/*
 * Decompiled with CFR 0.152.
 */
package other.commonutils.properties.propertiesset;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import other.commonutils.properties.propertiesset.PropertiesItem;

public class PropertyIterator {
    public static Iterable<PropertiesItem<String, Properties>> propertiesSet(Path initialPropFilePath, Function<Path, Properties> propertyLoader, Function<Properties, String> propertyIdGetter, Function<Properties, Iterable<String>> nextProperties) {
        Objects.requireNonNull(initialPropFilePath, "initialPropFilePath is null");
        Objects.requireNonNull(propertyLoader, "propertyLoader is null");
        Objects.requireNonNull(propertyIdGetter, "propertyIdGetter is null");
        Path currentPath = initialPropFilePath;
        boolean firstPass = true;
        ArrayList paths = new ArrayList();
        LinkedList<PropertiesItem<String, Properties>> list = new LinkedList<PropertiesItem<String, Properties>>();
        for (int index = 0; list.size() > index || firstPass; ++index) {
            if (firstPass) {
                firstPass = false;
            }
            Properties properties = propertyLoader.apply(currentPath);
            list.add(new PropItem(propertyIdGetter.apply(properties), properties));
        }
        return list;
    }

    public static Iterable<PropertiesItem<String, Properties>> propertiesSet(Path initialPropFilePath) {
        return PropertyIterator.propertiesSet(initialPropFilePath, new Function<Path, Properties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Properties apply(Path path) {
                Properties properties;
                Properties properties2 = new Properties();
                FileInputStream stream = new FileInputStream(path.toFile());
                try {
                    properties2.load(stream);
                    properties = properties2;
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                stream.close();
                return properties;
            }
        }, new Function<Properties, String>(){

            @Override
            public String apply(Properties properties) {
                String configType = properties.getProperty("configType");
                if (configType == null) {
                    throw new IllegalStateException("properties.getProperty(\"configType\") == null");
                }
                return configType;
            }
        }, new Function<Properties, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Properties properties) {
                LinkedList<String> list = new LinkedList<String>();
                for (Object o : properties.keySet()) {
                    String key = (String)o;
                    if (!key.contains("nextpropertyfile")) continue;
                    list.add(properties.getProperty(key));
                }
                return list;
            }
        });
    }

    private static class PropItem<PropertyKey, PropertyObject>
    implements PropertiesItem<PropertyKey, PropertyObject> {
        private final PropertyKey key;
        private final PropertyObject object;

        private PropItem(PropertyKey key, PropertyObject object) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.object = Objects.requireNonNull(object, "object is null");
        }

        @Override
        public PropertyKey key() {
            return this.key;
        }

        @Override
        public PropertyObject object() {
            return this.object;
        }
    }
}

