/*
 * Decompiled with CFR 0.152.
 */
package other.common.validation;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import other.common.utils.commonutils.CommonUtils;
import other.common.validation.ValidationFailed;

public class Validation {
    public static <K, V> Map<K, V> notEmpty(Map<K, V> map) {
        CommonUtils.check(() -> map != null, () -> new ValidationFailed("passed map can't be null"));
        CommonUtils.check(() -> !map.isEmpty(), () -> new ValidationFailed("passed map can't be empty"));
        return map;
    }

    public static <T, V extends Collection<T>> V notEmpty(V collection) {
        CommonUtils.check(() -> collection != null, () -> new ValidationFailed("passed collection can't be null"));
        CommonUtils.check(() -> !collection.isEmpty(), () -> new ValidationFailed("passed collection can't be empty"));
        return collection;
    }

    public static String notEmpty(String value) {
        CommonUtils.check(() -> value != null, () -> new ValidationFailed("passed string can't be null"));
        CommonUtils.check(() -> !value.isEmpty(), () -> new ValidationFailed("passed string can't be empty"));
        return value;
    }

    public static File fileOrDirExists(File file) {
        CommonUtils.check(() -> file != null, () -> new ValidationFailed("passed file can't be null"));
        CommonUtils.check(() -> !file.getPath().trim().isEmpty(), () -> new ValidationFailed("passed file path can't be empty"));
        CommonUtils.check(file::exists, () -> new ValidationFailed("No such file or directory -> \r\n" + file.getAbsolutePath()));
        return file;
    }
}

