/*
 * Decompiled with CFR 0.152.
 */
package other.common.utils.commonutils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class CommonUtils {
    private static final String UTF_8 = "utf-8";
    private static final BigInteger TWO = new BigInteger("2");
    private static final String SPACE = " ";

    private CommonUtils() {
    }

    public static String excludeTrailingBackslash(String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex != -1 && lastIndex == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String excludeFirstBackslash(String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        int indexOf = path.indexOf("/");
        if (indexOf == 0) {
            path = path.substring(1, path.length());
        }
        return path;
    }

    public static boolean allThreadsAreDone(Thread ... threads) {
        if (threads == null) {
            throw new NullPointerException("threads is null");
        }
        for (Thread thread : threads) {
            if (thread != null) continue;
            throw new NullPointerException("thread is null");
        }
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    public static String normalizeString(String data) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(data, " \t\n\r\f\u00a0", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            builder.append(token);
            builder.append(SPACE);
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - SPACE.length());
        }
        return builder.toString();
    }

    public static String removeSpacesAndReturns(String data) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(data, " \t\n\r\f\u00a0", false);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().replace(SPACE, "");
            builder.append(next);
        }
        return builder.toString();
    }

    public static boolean compareStreams(InputStream stream1, InputStream stream2) throws IOException {
        int read;
        Objects.requireNonNull(stream1, "stream1 is null");
        Objects.requireNonNull(stream2, "stream2 is null");
        if (stream1 == stream2) {
            return true;
        }
        while ((read = stream1.read()) == stream2.read()) {
            if (read != -1) continue;
            return true;
        }
        return false;
    }

    public static <T1, T2> boolean objectsAreEqual(T1 t1, T2 t2, BiFunction<T1, T2, Boolean> f) {
        return Objects.requireNonNull(f).apply(t1, t2);
    }

    public static URI getResourceUri(Class<?> clazz, String relativeResourcePath) throws URISyntaxException {
        URL resource = clazz.getResource(relativeResourcePath);
        if (resource == null) {
            throw new IllegalStateException("clazz.getResource(" + relativeResourcePath + ") == null");
        }
        return resource.toURI();
    }

    public static String getAbsoluteResourcePath(Class<?> clazz, String resourceName) {
        URL resource = clazz.getResource(clazz.getSimpleName() + ".class");
        if (resource == null) {
            throw new IllegalStateException("resource is null");
        }
        return Paths.get(CommonUtils.excludeTrailingBackslash(new File(resource.getFile()).getParent()), "/", CommonUtils.excludeFirstBackslash(resourceName)).normalize().toFile().getAbsolutePath();
    }

    public static int[] asArray(int length, int ... i) {
        if (i == null) {
            throw new NullPointerException("i is null");
        }
        if (length != i.length) {
            throw new IllegalStateException("length of an array " + Arrays.toString(i) + " does not correspond to " + length);
        }
        return (int[])i.clone();
    }

    @SafeVarargs
    public static <T> T[] checkToArray(int length, T ... items) {
        if (length != Objects.requireNonNull(items, "items is null").length) {
            throw new IllegalStateException("length of an array " + Arrays.toString(items) + " does not correspond to " + length);
        }
        return (Object[])items.clone();
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... items) {
        return CommonUtils.checkToArray(Objects.requireNonNull(items, "items is null").length, items);
    }

    /*
     * Exception decompiling
     */
    public static InputStream openClassResource(Class<?> clazz) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream loadResourceFromZipFile(Class<?> clazz, String relativePath, String zipItemPath) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("clazz is null");
        }
        if (relativePath == null) {
            throw new NullPointerException("relativePath is null");
        }
        if (zipItemPath == null) {
            throw new NullPointerException("zipItemPath is null");
        }
        String absolutePathToZip = CommonUtils.getAbsoluteResourcePath(clazz, relativePath);
        try (ZipFile zip = new ZipFile(absolutePathToZip);){
            ZipEntry entry = zip.getEntry(zipItemPath);
            if (entry == null) {
                throw new IllegalStateException("zip.getEntry(" + zipItemPath + ") == null. Item " + zipItemPath + " not found in zip file " + zipItemPath);
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry), 1024);){
                CommonUtils.copyStreamContent(inputStream, buffer);
                buffer.flush();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
            return byteArrayInputStream;
        }
    }

    public static <T> List<T> expandListToSize(List<T> list, int size) {
        while (list.size() < size) {
            list.add(null);
        }
        return list;
    }

    public static <T, K> T getValueFunction(K data, Function<K, T> function) {
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        return function.apply(data);
    }

    public static long measureTime(Code code, int count) throws Exception {
        Objects.requireNonNull(code, "code is null");
        if (count <= 0) {
            throw new IllegalArgumentException("count must be a positive number");
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            code.execute();
        }
        return System.currentTimeMillis() - l;
    }

    public static long measureTime(Code code) throws Exception {
        return CommonUtils.measureTime(code, 1);
    }

    public static <T> void suppressResult(T t) {
    }

    public static String compileString(Object mandatoryPart, Object ... testStepInfoParts) {
        Objects.requireNonNull(mandatoryPart, "mandatoryPart is null");
        Objects.requireNonNull(testStepInfoParts, "testStepInfoParts is null");
        for (Object o : testStepInfoParts) {
            Objects.requireNonNull(o, "one of params is null " + Arrays.toString(testStepInfoParts));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(mandatoryPart);
        for (Object o : testStepInfoParts) {
            builder.append(o);
        }
        return "" + builder;
    }

    public static <T> T checkDefined(T t, Object ... messages) {
        if (t == null) {
            throw new IllegalArgumentException(CommonUtils.compileString(messages, new Object[0]));
        }
        return t;
    }

    public static void suppressExceptions(Code code) {
        try {
            code.execute();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public static void delay(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T skipExceptions(SupressedExceptionSupplier<T> code, final T defaultValue) {
        return CommonUtils.skipExceptions(code, new Function<Exception, T>(){

            @Override
            public T apply(Exception e) {
                return defaultValue;
            }
        });
    }

    public static <T> T skipExceptions(SupressedExceptionSupplier<T> code, Function<Exception, T> defaultValue) {
        try {
            return code.execute();
        }
        catch (Exception e) {
            return defaultValue.apply(e);
        }
    }

    public static void skipExceptions(Code code, Runnable errorCaseCode) {
        block2: {
            try {
                code.execute();
            }
            catch (Throwable e) {
                if (errorCaseCode == null) break block2;
                errorCaseCode.run();
            }
        }
    }

    public static void skipExceptions(Code code, Consumer<Throwable> errorCaseCode) {
        block2: {
            try {
                code.execute();
            }
            catch (Throwable e) {
                if (errorCaseCode == null) break block2;
                errorCaseCode.accept(e);
            }
        }
    }

    public static void skipExceptions(Code code) {
        CommonUtils.skipExceptions(code, (Runnable)null);
    }

    public static void skipAllExceptions(Executable code) {
        Objects.requireNonNull(code, "code is null");
        try {
            code.execute();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T suppress(SupressedExceptionSupplier<T> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return supplier.execute();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void suppressWOResult(Code code) {
        Objects.requireNonNull(code);
        try {
            code.execute();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void suppressAllWOResult(Executable code) {
        Objects.requireNonNull(code);
        try {
            code.execute();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T suppress(SupressedExceptionSupplier<T> suppressedCode, Class<T> type) {
        Objects.requireNonNull(type);
        return CommonUtils.suppress(suppressedCode);
    }

    public static <T> T suppressAll(SupressedThrowableSupplier<T> supplier) {
        Objects.requireNonNull(supplier);
        try {
            return supplier.execute();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T suppressAll(SupressedThrowableSupplier<T> supplier, Class<T> resutType) {
        return CommonUtils.suppressAll(supplier);
    }

    public static <T> T ensure(T t, Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return t != null ? t : Objects.requireNonNull(supplier.get());
    }

    public static void copyStreamContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int actuallyRead;
        Objects.requireNonNull(inputStream, "inputStream is null");
        Objects.requireNonNull(outputStream, "outputStream is null");
        byte[] buffer = new byte[128];
        while ((actuallyRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, actuallyRead);
        }
    }

    public static <T> List<T> arrayToList(T ... arr) {
        Objects.requireNonNull(arr, "arr is null");
        return new ArrayList<T>(Arrays.asList(arr));
    }

    public static <T> T reduceUnique(T t1, T t2) {
        if (t1 == null && t2 == null) {
            throw new IllegalArgumentException("one of arguments must be defined.");
        }
        if (t1 != null && t2 != null && t1 != t2) {
            throw new IllegalArgumentException("defined arguments must be equal.");
        }
        return t1 == null ? t2 : t1;
    }

    @SafeVarargs
    public static <T> Collection<T> intersectCollections(Collection<T> ... sets) {
        Objects.requireNonNull(sets);
        Stream.of(sets).forEach(o -> Objects.requireNonNull(o));
        Set collect = Stream.of(sets).collect(HashSet::new, (c1, c2) -> c1.addAll(c2), (c1, c2) -> c1.addAll(c2));
        Stream.of(sets).forEach(i -> collect.retainAll((Collection<?>)i));
        return collect;
    }

    public static <T> T eval(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return supplier.get();
    }

    public static void check(BooleanSupplier condition, Supplier<? extends RuntimeException> error) {
        Objects.requireNonNull(error);
        Objects.requireNonNull(condition);
        if (!condition.getAsBoolean()) {
            throw error.get();
        }
    }

    public static <T> T check(Supplier<T> supplier, Predicate<T> predicate, Supplier<? extends RuntimeException> error) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(error);
        T result = supplier.get();
        if (!predicate.test(result)) {
            throw error.get();
        }
        return result;
    }

    public static void skipErrors(Code code, Consumer<Throwable> errorCaseCode) {
        block2: {
            Objects.requireNonNull(code);
            try {
                code.execute();
            }
            catch (Throwable e) {
                if (errorCaseCode == null) break block2;
                errorCaseCode.accept(e);
            }
        }
    }

    public static String stackTrace(Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            t.printStackTrace(new PrintStream(stream));
            String string = CommonUtils.suppress(() -> stream.toString(UTF_8));
            return string;
        }
        finally {
            CommonUtils.suppressWOResult(stream::close);
        }
    }

    public static <T extends Enum> Iterable<Set<T>> setCombinations(final Class<T> clazz) {
        CommonUtils.check(clazz::isEnum, IllegalStateException::new);
        return new Iterable<Set<T>>(){
            final List<T> enumElements;
            final BigInteger max;
            final Map<Integer, T> association;
            {
                this.enumElements = Arrays.asList(clazz.getEnumConstants());
                this.max = TWO.pow(this.enumElements.size()).subtract(BigInteger.ONE);
                this.association = new HashMap<Integer, T>(){
                    {
                        for (int n = 0; n < enumElements.size(); ++n) {
                            this.put(n, enumElements.get(n));
                        }
                    }
                };
            }

            @Override
            public Iterator<Set<T>> iterator() {
                return new Iterator<Set<T>>(){
                    BigInteger current = BigInteger.ZERO;

                    @Override
                    public boolean hasNext() {
                        return max.compareTo(this.current) >= 0;
                    }

                    @Override
                    public Set<T> next() {
                        CommonUtils.check(this::hasNext, NoSuchElementException::new);
                        BigInteger current = this.current;
                        this.current = this.current.add(BigInteger.ONE);
                        return BigInteger.ZERO.equals(current) ? Collections.emptySet() : Collections.unmodifiableSet(Stream.of(current).flatMap(this::getStream).collect(Collectors.toSet()));
                    }

                    private Stream<T> getStream(BigInteger number) {
                        Stream.Builder<Enum> builder = Stream.builder();
                        for (int bitNo = 0; bitNo < number.bitLength(); ++bitNo) {
                            if (!number.testBit(bitNo)) continue;
                            builder.add(association.computeIfAbsent(bitNo, integer -> {
                                throw new IllegalStateException();
                            }));
                        }
                        return builder.build();
                    }
                };
            }
        };
    }

    @FunctionalInterface
    public static interface SupressedThrowableSupplier<T> {
        public T execute() throws Throwable;
    }

    @FunctionalInterface
    public static interface SupressedExceptionSupplier<T> {
        public T execute() throws Exception;
    }

    @FunctionalInterface
    public static interface Executable {
        public void execute() throws Throwable;
    }

    @FunctionalInterface
    public static interface Code {
        public void execute() throws Exception;
    }
}

