/*
 * Decompiled with CFR 0.152.
 */
package other.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Properties;

public class ResourceUtils {
    public static InputStream loadResourceByRelativePath(Class startClass, String relativeResourcePath) {
        Objects.requireNonNull(startClass, "startClass is null");
        Objects.requireNonNull(relativeResourcePath, "relativeResourcePath is null");
        InputStream resource = startClass.getResourceAsStream(relativeResourcePath);
        if (resource == null) {
            throw new IllegalArgumentException("resource with path " + relativeResourcePath + " is not found. search from class " + startClass);
        }
        return resource;
    }

    /*
     * Exception decompiling
     */
    public static String loadResourceAsString(Class startClass, String resourcePath, Charset charset) throws IllegalArgumentException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] loadResourceAsBytes(Class startClass, String resourcePath) throws IOException {
        try (InputStream stream = ResourceUtils.loadResourceByRelativePath(startClass, resourcePath);){
            int read;
            byte[] buf = new byte[128];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = stream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static Properties loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public static Properties loadResourceAsProperties(Class startClass, String resourcePath) throws IllegalArgumentException, IOException {
        try (InputStream inputStream = ResourceUtils.loadResourceByRelativePath(startClass, resourcePath);){
            Properties properties = ResourceUtils.loadProperties(inputStream);
            return properties;
        }
    }

    public static String classFileName(Class clazz) {
        Objects.requireNonNull(clazz);
        String className = clazz.getPackage() != null ? clazz.getName().substring((clazz.getPackage().getName() + ".").length()) : clazz.getName();
        return className + ".class";
    }
}

