/*
 * Decompiled with CFR 0.152.
 */
package other.common.log;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

public class LocationUtils {
    public static String findClassFolder(String className) {
        Class<?> clazz;
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        if (!className.equals(clazz.getName())) {
            throw new IllegalStateException("!className.equals(clazz.getName())");
        }
        return LocationUtils.findFolderOfClass(clazz);
    }

    public static String findFolderOfClass(Class<?> clazz) {
        int lastDotIndex = clazz.getName().lastIndexOf(".");
        String classResourceName = lastDotIndex == -1 ? clazz.getName() + ".class" : clazz.getName().substring(lastDotIndex + 1, clazz.getName().length()) + ".class";
        String packageName = lastDotIndex == -1 ? "" : clazz.getName().substring(0, lastDotIndex).replace(".", "/");
        URL classResource = clazz.getResource(classResourceName);
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            switch (classResource.getProtocol().toLowerCase()) {
                case "zip": 
                case "jar": {
                    return new File(url.toURI()).getParent();
                }
                case "file": {
                    return new File(new File(url.toURI()), packageName).getPath();
                }
            }
            throw new IllegalStateException("unsupported protocol " + url.getProtocol());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

