/*
 * Decompiled with CFR 0.152.
 */
package other.common.lazyeval;

import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface LazyEval<T> {
    public T value();

    default public boolean evaluated() {
        return false;
    }

    public static <T> LazyEval<T> eval(final Supplier<T> eval) {
        Objects.requireNonNull(eval);
        return new LazyEval<T>(){
            private T t;
            private volatile boolean evaluated;

            @Override
            public T value() {
                if (!this.evaluated) {
                    this.t = eval.get();
                    this.evaluated = true;
                }
                return this.t;
            }

            @Override
            public boolean evaluated() {
                return this.evaluated;
            }
        };
    }
}

