/*
 * Decompiled with CFR 0.152.
 */
package other.common.autoclocablewrapper;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;

public class CloseableWrapper<T>
implements Closeable {
    private final T nexus;
    private final Consumer<T> consumer;

    public static <T> CloseableWrapper<T> closeable(T nexus, Consumer<T> consumer) {
        return new CloseableWrapper<T>(nexus, consumer);
    }

    public CloseableWrapper(T nexus, Consumer<T> consumer) {
        this.nexus = nexus;
        this.consumer = Objects.requireNonNull(consumer);
    }

    public T nexus() {
        return this.nexus;
    }

    @Override
    public void close() throws IOException {
        this.consumer.accept(this.nexus);
    }
}

