/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.utils;

import com.steammachine.jsonchecker.types.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TreeFlatter {
    public static List<TreeNode> flatten(TreeNode root) {
        Objects.requireNonNull(root);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        list.add(root);
        for (int index = 0; index < list.size(); ++index) {
            TreeNode node = (TreeNode)list.get(index);
            Iterator<TreeNode> children = node.children();
            while (children.hasNext()) {
                list.add(children.next());
            }
        }
        return list;
    }

    public static List<TreeNode> flatten(TreeNode root, Predicate<TreeNode> filter) {
        Objects.requireNonNull(root);
        Objects.requireNonNull(filter);
        return TreeFlatter.flatten(root).stream().filter(filter).collect(Collectors.toList());
    }
}

