/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.flatter2;

import com.steammachine.jsonchecker.impl.flatter2.ValueKey;
import com.steammachine.jsonchecker.types.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import other.common.utils.commonutils.CommonUtils;

public class PathCluster {
    private final Map<String, Path> pathMap = new HashMap<String, Path>();
    private final ValueKey valueKey;
    private final Object value;

    public PathCluster(ValueKey valueKey, Object value, Map<String, Path> pathMap) {
        this.valueKey = valueKey;
        this.value = value;
        this.pathMap.putAll(pathMap);
    }

    public PathCluster(ValueKey valueKey, Object value) {
        this.valueKey = valueKey;
        this.value = value;
    }

    public Set<String> kinds() {
        return this.pathMap.keySet();
    }

    public Object value() {
        return this.value;
    }

    public static PathCluster of(ValueKey valueKey, Object value) {
        return new PathCluster(valueKey, value);
    }

    public PathCluster putPath(String name, Path path) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(name);
        this.pathMap.put(name, path);
        return this;
    }

    public ValueKey valueKey() {
        return this.valueKey;
    }

    public Path path(String kind) {
        return this.pathMap.get(kind);
    }

    public void merge(PathCluster cluster) {
        CommonUtils.check(() -> Objects.equals(this.valueKey, cluster.valueKey), IllegalStateException::new);
        CommonUtils.check(() -> Objects.equals(this.value, cluster.value), IllegalStateException::new);
        this.pathMap.putAll(cluster.pathMap);
    }

    public static PathCluster merge(PathCluster pc1, PathCluster pc2) {
        Objects.requireNonNull(pc1);
        Objects.requireNonNull(pc2);
        CommonUtils.check(() -> Objects.equals(pc1.valueKey, pc2.valueKey), IllegalStateException::new);
        CommonUtils.check(() -> Objects.equals(pc1.value, pc2.value), IllegalStateException::new);
        HashMap<String, Path> map = new HashMap<String, Path>();
        map.putAll(pc1.pathMap);
        map.putAll(pc2.pathMap);
        return new PathCluster(pc1.valueKey, pc1.value, map);
    }

    public Map<String, Path> unmodifiablePathMap() {
        return Collections.unmodifiableMap(this.pathMap);
    }
}

