/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.directcomparison.pathformats;

import com.steammachine.jsonchecker.impl.flatter2.Element;
import com.steammachine.jsonchecker.impl.flatter2.IdentifierType;
import com.steammachine.jsonchecker.types.Path;
import com.steammachine.jsonchecker.types.PathParticle;
import java.util.Objects;
import other.common.utils.commonutils.CommonUtils;

class PathApplication {
    private static final Path UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX = Path.builder().ast().ast().del().get();
    private static final Path UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX = Path.builder().ast().ast().ast().del().get();
    private static final Path TWO_ASTERIX_AT_THE_END = Path.builder().del().ast().ast().get();

    PathApplication() {
    }

    @Deprecated
    public static boolean isPathAppliedOld(Path path, Path template) {
        if (template.startsWith(UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX)) {
            Path universalExclusion = template.subPath(UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX.particles().size());
            if (path.elements().size() < universalExclusion.elements().size()) {
                return false;
            }
            Path cutPathParts = path.subPath(path.particles().size() - universalExclusion.particles().size(), path.particles().size());
            CommonUtils.check(() -> cutPathParts.particles().size() == universalExclusion.particles().size(), () -> new IllegalStateException("sizes are not equal"));
            CommonUtils.check(() -> cutPathParts.elements().size() == universalExclusion.elements().size(), () -> new IllegalStateException("sizes are not equal"));
            int length = universalExclusion.elements().size();
            boolean scanResult = true;
            for (int index = 0; index < length; ++index) {
                scanResult = PathApplication.match(cutPathParts.elements().get(index), universalExclusion.elements().get(index)) && scanResult;
            }
            return scanResult;
        }
        if (template.startsWith(UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX)) {
            Path universalExclusion = template.subPath(UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX.particles().size());
            if (path.elements().size() < universalExclusion.elements().size()) {
                return false;
            }
            int iterationsCount = path.elements().size() - universalExclusion.elements().size() + 1;
            for (int iteration = 0; iteration < iterationsCount; ++iteration) {
                boolean scanResult = true;
                for (int index = 0; index < universalExclusion.elements().size(); ++index) {
                    scanResult = scanResult && PathApplication.match(path.elements().get(iteration + index), universalExclusion.elements().get(index));
                }
                if (!scanResult) continue;
                return true;
            }
            return false;
        }
        if (template.elements().size() == path.elements().size()) {
            int length = template.elements().size();
            boolean scanResult = true;
            for (int index = 0; index < length; ++index) {
                scanResult = PathApplication.match(path.elements().get(index), template.elements().get(index)) && scanResult;
            }
            return scanResult;
        }
        if (template.elements().size() < path.elements().size()) {
            return false;
        }
        if (template.elements().size() > path.elements().size()) {
            return false;
        }
        throw new IllegalStateException(" Illegal State ");
    }

    static boolean isPathApplied(Path path, Path template) {
        if (template.endsWith(TWO_ASTERIX_AT_THE_END)) {
            return PathApplication.asterixesAtTheEnd(path, template);
        }
        return PathApplication.noAsterixesAtTheEnd(path, template);
    }

    private static boolean noAsterixesAtTheEnd(Path path, Path template) {
        if (template.startsWith(UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX)) {
            Path universalExclusion = template.subPath(UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX.particles().size());
            if (path.elements().size() < universalExclusion.elements().size()) {
                return false;
            }
            Path cutPathParts = path.subPath(path.particles().size() - universalExclusion.particles().size(), path.particles().size());
            CommonUtils.check(() -> cutPathParts.particles().size() == universalExclusion.particles().size(), IllegalStateException::new);
            CommonUtils.check(() -> cutPathParts.elements().size() == universalExclusion.elements().size(), IllegalStateException::new);
            return PathApplication.elementsMatch(universalExclusion, cutPathParts, 0);
        }
        if (template.startsWith(UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX)) {
            Path universalExclusion = template.subPath(UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX.particles().size());
            if (path.elements().size() < universalExclusion.elements().size()) {
                return false;
            }
            int iterationsCount = path.elements().size() - universalExclusion.elements().size() + 1;
            for (int iteration = 0; iteration < iterationsCount; ++iteration) {
                if (!PathApplication.elementsMatch(universalExclusion, path, iteration)) continue;
                return true;
            }
            return false;
        }
        if (template.elements().size() == path.elements().size()) {
            return PathApplication.elementsMatch(template, path, 0);
        }
        if (template.elements().size() < path.elements().size()) {
            return false;
        }
        if (template.elements().size() > path.elements().size()) {
            return false;
        }
        throw new IllegalStateException(" Illegal State ");
    }

    private static boolean asterixesAtTheEnd(Path path, Path template) {
        CommonUtils.check(() -> template.endsWith(TWO_ASTERIX_AT_THE_END), IllegalStateException::new);
        if (template.startsWith(UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX)) {
            Path universalExclusion = template.subPath(UNIVERSAL_TEMPLATE_PREFIX_2_ASTERIX.particles().size(), template.particles().size() - TWO_ASTERIX_AT_THE_END.particles().size());
            if (path.elements().size() < universalExclusion.elements().size()) {
                return false;
            }
            int iterationCount = path.elements().size() - universalExclusion.elements().size();
            boolean scanResult = false;
            for (int iteration = 0; iteration < iterationCount; ++iteration) {
                scanResult = scanResult || PathApplication.elementsMatch(universalExclusion, path, iteration);
            }
            return scanResult;
        }
        if (template.startsWith(UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX)) {
            Path universalExclusion = template.subPath(UNIVERSAL_TEMPLATE_PREFIX_3_ASTERIX.particles().size(), template.particles().size() - TWO_ASTERIX_AT_THE_END.particles().size());
            if (path.elements().size() < universalExclusion.elements().size()) {
                return false;
            }
            int iterationsCount = path.elements().size() - universalExclusion.elements().size();
            boolean scanResult = false;
            for (int iteration = 0; iteration < iterationsCount; ++iteration) {
                scanResult = scanResult || PathApplication.elementsMatch(universalExclusion, path, iteration);
            }
            return scanResult;
        }
        Path universalExclusion = template.subPath(0, template.particles().size() - TWO_ASTERIX_AT_THE_END.particles().size());
        return path.particles().size() - universalExclusion.particles().size() > 0 && PathApplication.elementsMatch(universalExclusion, path, 0);
    }

    private static boolean elementsMatch(Path template, Path path, int startingFrom) {
        if (template.elements().size() + startingFrom > path.elements().size()) {
            return false;
        }
        boolean result = true;
        for (int index = 0; index < template.elements().size(); ++index) {
            result = result && PathApplication.match(path.elements().get(index + startingFrom), template.elements().get(index));
        }
        return result;
    }

    private static boolean match(Element path, Element templatePart) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(templatePart);
        if (templatePart.type().in(PathParticle.ParticleType.ANYELEMENT) && path.type().in(PathParticle.ParticleType.ELEMENT) && path.list().stream().anyMatch(i -> i.type().in(IdentifierType.notArrayItem))) {
            return true;
        }
        if (templatePart.type().in(PathParticle.ParticleType.ELEMENT) && templatePart.list().stream().anyMatch(i -> i.type().in(IdentifierType.anyArrayItem)) && path.type().in(PathParticle.ParticleType.ELEMENT) && path.list().stream().anyMatch(i -> i.type().in(IdentifierType.arrayItem, IdentifierType.anyArrayItem))) {
            return true;
        }
        return !CommonUtils.intersectCollections(path.list(), templatePart.list()).isEmpty();
    }
}

