/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.directcomparison.pathformats;

import com.steammachine.jsonchecker.defaults.AddressType;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.DotFormat;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.MonkeyIdCompTypeFormat;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.PathFormat;
import com.steammachine.jsonchecker.types.Path;
import com.steammachine.jsonchecker.types.exceptions.PathError;
import com.steammachine.jsonchecker.types.exceptions.WrongDataFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import other.common.lazyeval.LazyBuider;
import other.common.lazyeval.LazyEval;
import other.common.utils.commonutils.CommonUtils;

public class Formats {
    private static final LazyEval<Map<String, PathFormat>> PATH_FORMATS = LazyEval.eval(() -> {
        HashMap<String, PathFormat> map = new HashMap<String, PathFormat>();
        map.put(AddressType.direct.name(), new DotFormat());
        map.put(AddressType.monkey.name(), new MonkeyIdCompTypeFormat());
        return Collections.unmodifiableMap(map);
    });

    public static Stream<PathFormat> formats() {
        return PATH_FORMATS.value().values().stream();
    }

    public static void checkPathFormat(String path) {
        if (PATH_FORMATS.value().values().stream().noneMatch(f -> f.checkPathFormat(path))) {
            throw new PathError((Object)("path " + path + " is not correct path "));
        }
        if (PATH_FORMATS.value().values().stream().filter(f -> f.checkPathFormat(path)).count() > 1L) {
            throw new PathError(LazyBuider.lazy(() -> "path " + path + " is matched more than one format  " + PATH_FORMATS.value().values().stream().filter(f -> f.checkPathFormat(path)).map(PathFormat::name).collect(Collectors.joining(","))));
        }
    }

    public static boolean isApplied(String kind, Path path, Path pathTemplate) {
        PathFormat pathFormat = PATH_FORMATS.value().get(kind);
        CommonUtils.check(() -> pathFormat != null, IllegalStateException::new);
        return pathFormat.isApplied(path, pathTemplate);
    }

    public static String formatType(String path) {
        return PATH_FORMATS.value().entrySet().stream().filter(e -> ((PathFormat)e.getValue()).checkPathFormat(path)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new WrongDataFormat("path " + path + " does not match any format"));
    }

    public static PathFormat format(String data) {
        PathFormat pathFormat = PATH_FORMATS.value().get(data);
        CommonUtils.check(() -> pathFormat != null, IllegalStateException::new);
        return pathFormat;
    }
}

