/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.directcomparison.pathformats;

import com.steammachine.jsonchecker.impl.directcomparison.pathformats.PathApplication;
import com.steammachine.jsonchecker.impl.directcomparison.pathformats.PathFormat;
import com.steammachine.jsonchecker.types.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import other.common.lazyeval.LazyEval;
import other.common.utils.commonutils.CommonUtils;

public class DotFormat
implements PathFormat {
    private static final String AST = Pattern.quote("*");
    private static final String LB = Pattern.quote("[");
    private static final String RB = Pattern.quote("]");
    private static final String POINT = Pattern.quote(".");
    private static final LazyEval<Map<MatcherId, Pattern>> PATTERNS = LazyEval.eval(() -> {
        HashMap<MatcherId, Pattern> map = new HashMap<MatcherId, Pattern>();
        map.put(MatcherId.POINT, Pattern.compile(POINT));
        map.put(MatcherId.NUMBER, Pattern.compile("^\\d+$"));
        map.put(MatcherId.ASTERIX, Pattern.compile(AST));
        map.put(MatcherId.TWO_ASTERIXES, Pattern.compile(AST + AST));
        map.put(MatcherId.BRACKETS_GROUP, Pattern.compile(LB + "([.&&[^" + LB + "]]&&[^" + RB + "])*" + RB));
        return Collections.unmodifiableMap(map);
    });

    @Override
    public String name() {
        return "dot";
    }

    @Override
    public boolean checkPathFormat(String path) {
        boolean universal;
        String data;
        if (path.startsWith("**.")) {
            data = path.substring("**.".length());
            universal = true;
        } else if (path.startsWith("***.")) {
            data = path.substring("***.".length());
            universal = true;
        } else {
            data = path;
            universal = false;
        }
        String[] items = data.split(DotFormat.pattern(MatcherId.POINT).pattern());
        return !path.startsWith(".") && !path.endsWith(".") && items.length != 0 && Stream.iterate(0, i -> i + 1).limit(items.length).map(i -> new AuxParam(universal, i == 0, i == items.length - 1, items[i])).allMatch(DotFormat::isMatched);
    }

    @Override
    public Path parsePath(String path) {
        boolean universal;
        CommonUtils.check(() -> this.checkPathFormat(path), () -> new IllegalStateException("path " + path + " is not valid"));
        String currPath = path;
        Path.Builder pathBuilder = Path.builder();
        if (currPath.startsWith("**.")) {
            currPath = path.substring("**.".length());
            pathBuilder.ast().ast().del();
            universal = true;
        } else if (path.startsWith("***.")) {
            currPath = path.substring("***.".length());
            pathBuilder.ast().ast().ast().del();
            universal = true;
        } else {
            universal = false;
        }
        String[] items = currPath.split(DotFormat.pattern(MatcherId.POINT).pattern());
        ((Stream)Stream.iterate(0, i -> i + 1).limit(items.length).map(i -> new AuxParam(universal, i == 0, i == items.length - 1, items[i])).sequential()).forEach(t -> DotFormat.auxToPath(t, pathBuilder));
        return pathBuilder.get();
    }

    @Override
    public boolean isApplied(Path path, Path templatePath) {
        return PathApplication.isPathApplied(path, templatePath);
    }

    private static boolean anyMatch(String data, MatcherId ... ids) {
        return Stream.of(ids).anyMatch(i -> DotFormat.pattern(i).matcher(data).matches());
    }

    private static boolean isValidName(String item) {
        return item.chars().allMatch(cp -> Character.isJavaIdentifierPart(cp) || cp == 58);
    }

    private static void auxToPath(AuxParam param, Path.Builder builder) {
        if (!param.data().contains("[")) {
            DotFormat.processNoArrayItem(param, builder);
        } else {
            String prefix = param.data().substring(0, param.data().indexOf("["));
            if (prefix.isEmpty()) {
                int index = 0;
                while (index < param.data().length()) {
                    int lbIndex = param.data().indexOf("[", index);
                    int rbIndex = param.data().indexOf("]", lbIndex + 1);
                    String inBrackets = param.data().substring(lbIndex + 1, rbIndex);
                    if (index != 0 || !param.universal() || !param.first()) {
                        builder.del();
                    }
                    if (DotFormat.anyMatch(inBrackets, MatcherId.ASTERIX)) {
                        builder.anyArr();
                    } else if (DotFormat.anyMatch(inBrackets, MatcherId.NUMBER)) {
                        builder.arr(Integer.parseInt(inBrackets));
                    } else {
                        throw new IllegalStateException();
                    }
                    index = rbIndex + 1;
                }
            } else {
                boolean firstDelimeterNeeded = param.first() && param.universal() ? false : (!param.first() && param.universal() ? true : (param.first() && !param.universal() ? false : !param.first() && !param.universal()));
                if (firstDelimeterNeeded) {
                    builder.del();
                }
                builder.obj(prefix);
                int index = 0;
                while (index < param.data().length()) {
                    int lbIndex = param.data().indexOf("[", index);
                    int rbIndex = param.data().indexOf("]", lbIndex + 1);
                    String inBrackets = param.data().substring(lbIndex + 1, rbIndex);
                    builder.del();
                    if (DotFormat.anyMatch(inBrackets, MatcherId.ASTERIX)) {
                        builder.anyArr();
                    } else if (DotFormat.anyMatch(inBrackets, MatcherId.NUMBER)) {
                        builder.arr(Integer.parseInt(inBrackets));
                    } else {
                        throw new IllegalStateException();
                    }
                    index = rbIndex + 1;
                }
            }
        }
    }

    private static void processNoArrayItem(AuxParam param, Path.Builder builder) {
        if (!param.first()) {
            builder.del();
        }
        if (DotFormat.isValidName(param.data())) {
            builder.obj(param.data());
        } else if (DotFormat.anyMatch(param.data(), MatcherId.ASTERIX)) {
            builder.ast();
        } else if (param.last() && DotFormat.anyMatch(param.data(), MatcherId.TWO_ASTERIXES)) {
            builder.ast().ast();
        } else {
            throw new IllegalStateException();
        }
    }

    private static boolean isMatched(AuxParam element) {
        if (element.data().trim().isEmpty()) {
            return false;
        }
        if (!element.data().contains("[")) {
            return DotFormat.isCorrectItem(element);
        }
        return DotFormat.isCorrectArrayItem(element);
    }

    private static boolean isCorrectItem(AuxParam element) {
        if (element.last()) {
            return DotFormat.anyMatch(element.data(), MatcherId.TWO_ASTERIXES) || DotFormat.anyMatch(element.data(), MatcherId.ASTERIX) || DotFormat.isValidName(element.data());
        }
        return DotFormat.anyMatch(element.data(), MatcherId.ASTERIX) || DotFormat.isValidName(element.data());
    }

    private static boolean isCorrectArrayItem(AuxParam auxParam) {
        if (auxParam.data().indexOf("[") == 0) {
            if (!auxParam.universal()) {
                return false;
            }
            if (!auxParam.first()) {
                return false;
            }
        }
        if (auxParam.data().indexOf("]") - auxParam.data().indexOf("[") < 2) {
            return false;
        }
        if (!auxParam.data().endsWith("]")) {
            return false;
        }
        if (!DotFormat.isValidName(auxParam.data().substring(0, auxParam.data().indexOf("[")))) {
            return false;
        }
        boolean result = true;
        int index = 0;
        while (index < auxParam.data().length()) {
            int lbIndex = auxParam.data().indexOf("[", index);
            if (lbIndex < 0) {
                return false;
            }
            int rbIndex = auxParam.data().indexOf("]", lbIndex + 1);
            if (rbIndex < 0) {
                return false;
            }
            index = rbIndex + 1;
            String inBrackets = auxParam.data().substring(lbIndex + 1, rbIndex);
            result = result && DotFormat.anyMatch(inBrackets, MatcherId.NUMBER, MatcherId.ASTERIX);
        }
        return result;
    }

    private static boolean isCorrectArrayItem(String data) {
        if (data.indexOf("[") == 0) {
            return false;
        }
        if (!data.endsWith("]")) {
            return false;
        }
        if (!DotFormat.isValidName(data.substring(0, data.indexOf("[")))) {
            return false;
        }
        boolean result = true;
        int index = 0;
        while (index < data.length()) {
            int lbIndex = data.indexOf("[", index);
            if (lbIndex < 0) {
                return false;
            }
            int rbIndex = data.indexOf("]", lbIndex + 1);
            if (rbIndex < 0) {
                return false;
            }
            index = rbIndex + 1;
            String inBrackets = data.substring(lbIndex + 1, rbIndex);
            result = result && DotFormat.anyMatch(inBrackets, MatcherId.NUMBER, MatcherId.ASTERIX);
        }
        return result;
    }

    private static Pattern pattern(MatcherId matcherId) {
        return PATTERNS.value().get((Object)matcherId);
    }

    private static enum MatcherId {
        POINT,
        NUMBER,
        ASTERIX,
        TWO_ASTERIXES,
        BRACKETS_GROUP;

    }

    private static class AuxParam {
        private final boolean universal;
        private final String data;
        private final boolean first;
        private final boolean last;

        private AuxParam(boolean universal, boolean first, boolean last, String data) {
            this.universal = universal;
            this.first = first;
            this.last = last;
            this.data = Objects.requireNonNull(data);
        }

        public boolean first() {
            return this.first;
        }

        public boolean last() {
            return this.last;
        }

        public boolean universal() {
            return this.universal;
        }

        public String data() {
            return this.data;
        }

        public String toString() {
            return "AuxParam(universal=" + this.universal + ", data=" + this.data + ", first=" + this.first + ", last=" + this.last + ")";
        }
    }
}

