/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.jsonchecker.impl.directcomparison.flatterprocs;

import com.steammachine.jsonchecker.defaults.AddressType;
import com.steammachine.jsonchecker.impl.directcomparison.flatterprocs.DirectFlatter;
import com.steammachine.jsonchecker.impl.directcomparison.flatterprocs.FlattingProc;
import com.steammachine.jsonchecker.impl.directcomparison.flatterprocs.MonkeyIdFlatter;
import com.steammachine.jsonchecker.impl.flatter2.ValRec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.simple.JSONObject;
import other.common.lazyeval.LazyEval;

public class Flatters {
    private static final LazyEval<Map<String, LazyEval<FlattingProc>>> FLATTERS = LazyEval.eval(() -> {
        HashMap<String, LazyEval<FlattingProc>> map = new HashMap<String, LazyEval<FlattingProc>>();
        map.put(AddressType.direct.name(), LazyEval.eval(() -> DirectFlatter::flattenJSonObject));
        map.put(AddressType.monkey.name(), LazyEval.eval(() -> MonkeyIdFlatter::flattenJSonObject));
        return Collections.unmodifiableMap(map);
    });

    public static List<ValRec> flatten(String kind, JSONObject o) {
        Objects.requireNonNull(kind);
        Objects.requireNonNull(o);
        LazyEval<FlattingProc> flatter = FLATTERS.value().get(kind);
        if (flatter == null) {
            throw new IllegalStateException("flatter of kind " + kind + " not found.");
        }
        return flatter.value().flatten(o);
    }
}

